// Namespace
FindArea = function(Client){
    Client.FindArea = function() {
        // Check If Able To Find Area
        if (Client.Pos == undefined || Client.CoreSize == undefined || Client.Pos == NaN || Client.CoreSize == NaN) {
            console.log('Client.Pos: ' + Client.Pos + ' Client.CoreSize: ' + Client.CoreSize);
            return;
        }const Space = [];

        // Determine the min and max values for each axis
        const minX = Math.floor(Client.Pos.x) + Math.min(Client.CoreSize.x, -Client.CoreSize.x);
        const maxX = Math.floor(Client.Pos.x) + Math.max(Client.CoreSize.x, -Client.CoreSize.x);
        const minY = Math.floor(Client.Pos.y) + Math.min(-1, -Client.CoreSize.y);
        const maxY = Math.floor(Client.Pos.y) + Math.max(-1, -Client.CoreSize.y);
        const minZ = Math.floor(Client.Pos.z) + Math.min(Client.CoreSize.z, -Client.CoreSize.z);
        const maxZ = Math.floor(Client.Pos.z) + Math.max(Client.CoreSize.z, -Client.CoreSize.z);

        // Iterate through each coordinate within the range
        for (let y = maxY; y >= minY; y--) {
            for (let z = maxZ; z >= minZ; z--) {
                for (let x = maxX; x >= minX; x--) {
                    Space.push({ x, y, z });
                }
            }
        }return Space;
    };
}

module.exports = FindArea;