/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.recipe.Recipes;
import thedarkcolour.futuremc.recipe.SimpleRecipe;
import thedarkcolour.futuremc.recipe.furnace.BlastFurnaceRecipes;
import thedarkcolour.futuremc.recipe.furnace.SmokerRecipes;

public class SmokerAndBlastFurnace {

    private static final class RemoveRecipeForOutput
    extends RemoveRecipeFor {
        private RemoveRecipeForOutput(Recipes<SimpleRecipe> recipes, IItemStack input) {
            super(recipes, input);
        }

        public void apply() {
            this.recipes.removeRecipeForInput(this.item);
        }
    }

    private static final class RemoveRecipeForInput
    extends RemoveRecipeFor {
        private RemoveRecipeForInput(Recipes<SimpleRecipe> recipes, IItemStack input) {
            super(recipes, input);
        }

        public void apply() {
            this.recipes.removeRecipeForInput(this.item);
        }
    }

    private static abstract class RemoveRecipeFor
    implements IAction {
        protected final Recipes<SimpleRecipe> recipes;
        protected final ItemStack item;

        private RemoveRecipeFor(Recipes<SimpleRecipe> recipes, IItemStack item) {
            this.recipes = recipes;
            this.item = CraftTweakerMC.getItemStack((IItemStack)item);
        }

        public String describe() {
            return this.recipes.getClass().getSimpleName() + ": " + this.getClass().getSimpleName() + " " + this.item.func_77973_b().getRegistryName();
        }
    }

    private static final class AddRecipe
    implements IAction {
        private final Recipes<SimpleRecipe> recipes;
        private final Ingredient input;
        private final ItemStack output;

        private AddRecipe(Recipes<SimpleRecipe> recipes, IIngredient input, IItemStack output) {
            this.recipes = recipes;
            this.input = CraftTweakerMC.getIngredient((IIngredient)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            this.recipes.addRecipe(this.input, this.output);
        }

        public String describe() {
            return this.recipes.getClass().getSimpleName() + ": Adding recipe (input: " + this.input.toString() + ") -> (output: " + this.output.toString() + ")";
        }
    }

    @ZenRegister
    @ZenClass(value="mods.futuremc.BlastFurnace")
    public static final class BlastFurnace {
        @ZenMethod
        public static void addRecipe(IIngredient input, IItemStack output) {
            CraftTweakerAPI.apply((IAction)new AddRecipe(BlastFurnaceRecipes.INSTANCE, input, output));
        }

        @ZenMethod
        public static void removeRecipe(IItemStack input) {
            CraftTweakerAPI.apply((IAction)new RemoveRecipeForInput(BlastFurnaceRecipes.INSTANCE, input));
        }

        @ZenMethod
        public static void removeRecipeForInput(IItemStack input) {
            BlastFurnace.removeRecipe(input);
        }

        @ZenMethod
        public static void removeRecipeForOutput(IItemStack output) {
            CraftTweakerAPI.apply((IAction)new RemoveRecipeForOutput(BlastFurnaceRecipes.INSTANCE, output));
        }

        @ZenMethod
        public static void clearRecipes() {
            BlastFurnaceRecipes.INSTANCE.clear();
        }
    }

    @ZenRegister
    @ZenClass(value="mods.futuremc.Smoker")
    public static final class Smoker {
        @ZenMethod
        public static void addRecipe(IIngredient input, IItemStack output) {
            CraftTweakerAPI.apply((IAction)new AddRecipe(SmokerRecipes.INSTANCE, input, output));
        }

        @ZenMethod
        public static void removeRecipe(IItemStack input) {
            CraftTweakerAPI.apply((IAction)new RemoveRecipeForInput(SmokerRecipes.INSTANCE, input));
        }

        @ZenMethod
        public static void removeRecipeForInput(IItemStack input) {
            Smoker.removeRecipe(input);
        }

        @ZenMethod
        public static void removeRecipeForOutput(IItemStack output) {
            CraftTweakerAPI.apply((IAction)new RemoveRecipeForOutput(SmokerRecipes.INSTANCE, output));
        }

        @ZenMethod
        public static void clearRecipes() {
            SmokerRecipes.INSTANCE.clear();
        }
    }
}

