/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app.component;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.IIcon;
import com.mrcrayfish.device.api.app.listener.ClickListener;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class Button
extends Component {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    protected static final int TOOLTIP_DELAY = 20;
    protected String text;
    protected String toolTip;
    protected String toolTipTitle;
    protected int toolTipTick;
    protected boolean hovered;
    protected int padding = 5;
    protected int width;
    protected int height;
    protected boolean explicitSize = false;
    protected ResourceLocation iconResource;
    protected int iconU;
    protected int iconV;
    protected int iconWidth;
    protected int iconHeight;
    protected int iconSourceWidth;
    protected int iconSourceHeight;
    protected ClickListener clickListener = null;

    public Button(int left, int top, String text) {
        super(left, top);
        this.width = Button.getTextWidth(text) + this.padding * 2;
        this.height = 16;
        this.text = text;
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, String text) {
        super(left, top);
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.text = text;
    }

    public Button(int left, int top, IIcon icon) {
        super(left, top);
        this.padding = 3;
        this.width = icon.getIconSize() + this.padding * 2;
        this.height = icon.getIconSize() + this.padding * 2;
        this.setIcon(icon);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, IIcon icon) {
        super(left, top);
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(icon);
    }

    public Button(int left, int top, String text, IIcon icon) {
        this(left, top, text);
        this.setIcon(icon);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, String text, IIcon icon) {
        super(left, top);
        this.text = text;
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(icon);
    }

    public Button(int left, int top, ResourceLocation iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.padding = 3;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, ResourceLocation iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public Button(int left, int top, String text, ResourceLocation iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.text = text;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    public Button(int left, int top, int buttonWidth, int buttonHeight, String text, ResourceLocation iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        super(left, top);
        this.text = text;
        this.explicitSize = true;
        this.width = buttonWidth;
        this.height = buttonHeight;
        this.setIcon(iconResource, iconU, iconV, iconWidth, iconHeight);
    }

    @Override
    protected void handleTick() {
        this.toolTipTick = this.hovered ? (this.toolTipTick = this.toolTipTick + 1) : 0;
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            mc.func_110434_K().func_110577_a(Component.COMPONENTS_GUI);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor()).brighter().brighter();
            float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
            bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], 1.0f));
            GL11.glColor4f((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
            this.hovered = GuiHelper.isMouseWithin(mouseX, mouseY, x, y, this.width, this.height) && windowActive;
            int i = this.getHoverState(this.hovered);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderUtil.drawRectWithTexture(x, y, 96 + i * 5, 12.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(x + this.width - 2, y, 99 + i * 5, 12.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(x + this.width - 2, y + this.height - 2, 99 + i * 5, 15.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(x, y + this.height - 2, 96 + i * 5, 15.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(x + 2, y, 98 + i * 5, 12.0f, this.width - 4, 2, 1.0f, 2.0f);
            RenderUtil.drawRectWithTexture(x + this.width - 2, y + 2, 99 + i * 5, 14.0f, 2, this.height - 4, 2.0f, 1.0f);
            RenderUtil.drawRectWithTexture(x + 2, y + this.height - 2, 98 + i * 5, 15.0f, this.width - 4, 2, 1.0f, 2.0f);
            RenderUtil.drawRectWithTexture(x, y + 2, 96 + i * 5, 14.0f, 2, this.height - 4, 2.0f, 1.0f);
            RenderUtil.drawRectWithTexture(x + 2, y + 2, 98 + i * 5, 14.0f, this.width - 4, this.height - 4, 1.0f, 1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int contentWidth = (this.iconResource != null ? this.iconWidth : 0) + Button.getTextWidth(this.text);
            if (this.iconResource != null && !StringUtils.func_151246_b((String)this.text)) {
                contentWidth += 3;
            }
            int contentX = (int)Math.ceil((double)(this.width - contentWidth) / 2.0);
            if (this.iconResource != null) {
                int iconY = (this.height - this.iconHeight) / 2;
                mc.func_110434_K().func_110577_a(this.iconResource);
                RenderUtil.drawRectWithTexture(x + contentX, y + iconY, this.iconU, this.iconV, this.iconWidth, this.iconHeight, this.iconWidth, this.iconHeight, this.iconSourceWidth, this.iconSourceHeight);
            }
            if (!StringUtils.func_151246_b((String)this.text)) {
                int textOffsetX;
                int textY = (this.height - mc.field_71466_p.field_78288_b) / 2 + 1;
                int n = textOffsetX = this.iconResource != null ? this.iconWidth + 3 : 0;
                int textColor = !this.enabled ? 0xA0A0A0 : (this.hovered ? 0xFFFFA0 : 0xE0E0E0);
                this.func_73731_b(mc.field_71466_p, this.text, x + contentX + textOffsetX, y + textY, textColor);
            }
        }
    }

    @Override
    public void renderOverlay(Laptop laptop, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        if (this.hovered && this.toolTip != null && this.toolTipTick >= 20) {
            laptop.func_146283_a(Arrays.asList(TextFormatting.GOLD + this.toolTipTitle, this.toolTip), mouseX, mouseY);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (this.hovered) {
            if (this.clickListener != null) {
                this.clickListener.onClick(mouseX, mouseY, mouseButton);
            }
            this.playClickSound(Minecraft.func_71410_x().func_147118_V());
        }
    }

    public final void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    protected void playClickSound(SoundHandler handler) {
        handler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected boolean isInside(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public void setSize(int width, int height) {
        this.explicitSize = true;
        this.width = width;
        this.height = height;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.updateSize();
    }

    public void setText(String text) {
        this.text = text;
        this.updateSize();
    }

    public String getText() {
        return this.text;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setIcon(ResourceLocation iconResource, int iconU, int iconV, int iconWidth, int iconHeight) {
        this.iconU = iconU;
        this.iconV = iconV;
        this.iconResource = iconResource;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.iconSourceWidth = 256;
        this.iconSourceHeight = 256;
        this.updateSize();
    }

    public void setIcon(IIcon icon) {
        this.iconU = icon.getU();
        this.iconV = icon.getV();
        this.iconResource = icon.getIconAsset();
        this.iconWidth = icon.getIconSize();
        this.iconHeight = icon.getIconSize();
        this.iconSourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.iconSourceHeight = icon.getGridHeight() * icon.getIconSize();
        this.updateSize();
    }

    public void removeIcon() {
        this.iconResource = null;
        this.updateSize();
    }

    private void updateSize() {
        if (this.explicitSize) {
            return;
        }
        int height = this.padding * 2;
        int width = this.padding * 2;
        if (this.iconResource != null) {
            width += this.iconWidth;
            height += this.iconHeight;
        }
        if (this.text != null) {
            width += Button.getTextWidth(this.text);
            height = 16;
        }
        if (this.iconResource != null && this.text != null) {
            width += 3;
            height = this.iconHeight + this.padding * 2;
        }
        this.width = width;
        this.height = height;
    }

    public void setToolTip(String toolTipTitle, String toolTip) {
        this.toolTipTitle = toolTipTitle;
        this.toolTip = toolTip;
    }

    private static int getTextWidth(String text) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean flag = fontRenderer.func_82883_a();
        fontRenderer.func_78264_a(false);
        int width = fontRenderer.func_78256_a(text);
        fontRenderer.func_78264_a(flag);
        return width;
    }
}

