/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.network;

import com.mrcrayfish.device.core.Device;
import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkDevice
extends Device {
    private NetworkDevice() {
    }

    public NetworkDevice(TileEntityNetworkDevice device) {
        super(device);
    }

    public NetworkDevice(UUID id, String name, Router router) {
        super(id, name);
    }

    public boolean isConnected(World world) {
        if (this.pos == null) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(this.pos);
        if (tileEntity instanceof TileEntityNetworkDevice) {
            TileEntityNetworkDevice device = (TileEntityNetworkDevice)tileEntity;
            Router router = device.getRouter();
            return router != null && router.getId().equals(router.getId());
        }
        return false;
    }

    @Override
    @Nullable
    public TileEntityNetworkDevice getDevice(World world) {
        TileEntityNetworkDevice tileEntityNetworkDevice;
        if (this.pos == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.pos);
        if (tileEntity instanceof TileEntityNetworkDevice && (tileEntityNetworkDevice = (TileEntityNetworkDevice)tileEntity).getId().equals(this.getId())) {
            return tileEntityNetworkDevice;
        }
        return null;
    }

    @Override
    public NBTTagCompound toTag(boolean includePos) {
        NBTTagCompound tag = super.toTag(includePos);
        if (includePos && this.pos != null) {
            tag.func_74772_a("pos", this.pos.func_177986_g());
        }
        return tag;
    }

    public static NetworkDevice fromTag(NBTTagCompound tag) {
        NetworkDevice device = new NetworkDevice();
        device.id = UUID.fromString(tag.func_74779_i("id"));
        device.name = tag.func_74779_i("name");
        if (tag.func_150297_b("pos", 4)) {
            device.pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
        }
        return device;
    }
}

