/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.network;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.core.network.NetworkDevice;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Router {
    private final Map<UUID, NetworkDevice> NETWORK_DEVICES = new HashMap<UUID, NetworkDevice>();
    private int timer;
    private UUID routerId;
    private BlockPos pos;

    public Router(BlockPos pos) {
        this.pos = pos;
    }

    public void update(World world) {
        if (++this.timer >= DeviceConfig.getBeaconInterval()) {
            this.sendBeacon(world);
            this.timer = 0;
        }
    }

    public boolean addDevice(UUID id, String name) {
        if (this.NETWORK_DEVICES.size() >= DeviceConfig.getMaxDevices()) {
            return this.NETWORK_DEVICES.containsKey(id);
        }
        if (!this.NETWORK_DEVICES.containsKey(id)) {
            this.NETWORK_DEVICES.put(id, new NetworkDevice(id, name, this));
        }
        this.timer = DeviceConfig.getBeaconInterval();
        return true;
    }

    public boolean addDevice(TileEntityNetworkDevice device) {
        if (this.NETWORK_DEVICES.size() >= DeviceConfig.getMaxDevices()) {
            return this.NETWORK_DEVICES.containsKey(device.getId());
        }
        if (!this.NETWORK_DEVICES.containsKey(device.getId())) {
            this.NETWORK_DEVICES.put(device.getId(), new NetworkDevice(device));
        }
        return true;
    }

    public boolean isDeviceRegistered(TileEntityNetworkDevice device) {
        return this.NETWORK_DEVICES.containsKey(device.getId());
    }

    public boolean isDeviceConnected(TileEntityNetworkDevice device) {
        return this.isDeviceRegistered(device) && this.NETWORK_DEVICES.get(device.getId()).getPos() != null;
    }

    public void removeDevice(TileEntityNetworkDevice device) {
        this.NETWORK_DEVICES.remove(device.getId());
    }

    @Nullable
    public TileEntityNetworkDevice getDevice(World world, UUID id) {
        return this.NETWORK_DEVICES.containsKey(id) ? this.NETWORK_DEVICES.get(id).getDevice(world) : null;
    }

    public Collection<NetworkDevice> getNetworkDevices() {
        return this.NETWORK_DEVICES.values();
    }

    public Collection<NetworkDevice> getConnectedDevices(World world) {
        this.sendBeacon(world);
        return this.NETWORK_DEVICES.values().stream().filter(networkDevice -> networkDevice.getPos() != null).collect(Collectors.toList());
    }

    public Collection<NetworkDevice> getConnectedDevices(World world, Class<? extends TileEntityNetworkDevice> type) {
        Predicate<NetworkDevice> DEVICE_TYPE = networkDevice -> {
            if (networkDevice.getPos() == null) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(networkDevice.getPos());
            if (tileEntity instanceof TileEntityNetworkDevice) {
                return type.isAssignableFrom(tileEntity.getClass());
            }
            return false;
        };
        return this.getConnectedDevices(world).stream().filter(DEVICE_TYPE).collect(Collectors.toList());
    }

    private void sendBeacon(World world) {
        if (world.field_72995_K) {
            return;
        }
        this.NETWORK_DEVICES.forEach((id, device) -> device.setPos(null));
        int range = DeviceConfig.getSignalRange();
        for (int y = -range; y < range + 1; ++y) {
            for (int z = -range; z < range + 1; ++z) {
                for (int x = -range; x < range + 1; ++x) {
                    TileEntityNetworkDevice tileEntityNetworkDevice;
                    BlockPos currentPos = new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
                    TileEntity tileEntity = world.func_175625_s(currentPos);
                    if (!(tileEntity instanceof TileEntityNetworkDevice) || !this.NETWORK_DEVICES.containsKey((tileEntityNetworkDevice = (TileEntityNetworkDevice)tileEntity).getId()) || !tileEntityNetworkDevice.receiveBeacon(this)) continue;
                    this.NETWORK_DEVICES.get(tileEntityNetworkDevice.getId()).update(tileEntityNetworkDevice);
                }
            }
        }
    }

    public UUID getId() {
        if (this.routerId == null) {
            this.routerId = UUID.randomUUID();
        }
        return this.routerId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public NBTTagCompound toTag(boolean includePos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("id", this.getId());
        NBTTagList deviceList = new NBTTagList();
        this.NETWORK_DEVICES.forEach((id, device) -> deviceList.func_74742_a((NBTBase)device.toTag(includePos)));
        tag.func_74782_a("network_devices", (NBTBase)deviceList);
        return tag;
    }

    public static Router fromTag(BlockPos pos, NBTTagCompound tag) {
        Router router = new Router(pos);
        router.routerId = tag.func_186857_a("id");
        NBTTagList deviceList = tag.func_150295_c("network_devices", 10);
        for (int i = 0; i < deviceList.func_74745_c(); ++i) {
            NetworkDevice device = NetworkDevice.fromTag(deviceList.func_150305_b(i));
            router.NETWORK_DEVICES.put(device.getId(), device);
        }
        return router;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Router)) {
            return false;
        }
        Router router = (Router)obj;
        return router.getId().equals(this.routerId);
    }
}

