/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs;

import com.mrcrayfish.device.api.app.Alphabet;
import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.IIcon;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.ComboBox;
import com.mrcrayfish.device.programs.system.layout.StandardLayout;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class ApplicationIcons
extends Application {
    private int offset;
    private StandardLayout layoutMain;
    private Layout layoutContainer;
    private ComboBox.List<IconSet> iconSetComboBox;

    public ApplicationIcons() {
        this.setDefaultWidth(332);
        this.setDefaultHeight(150);
    }

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.layoutMain = new StandardLayout(TextFormatting.BOLD + "Icons", 330, 153, this, null);
        this.layoutMain.setIcon(Icons.HOME);
        this.layoutContainer = new Layout(330, 153);
        this.layoutMain.addComponent(this.layoutContainer);
        IconSet[] iconSets = new IconSet[]{new IconSet("Standard Icons", Icons.values()), new IconSet("Alphabet", Alphabet.values())};
        this.iconSetComboBox = new ComboBox.List<IconSet>(191, 3, 100, iconSets);
        this.iconSetComboBox.setChangeListener((oldValue, newValue) -> {
            this.offset = 0;
            this.updateIcons();
        });
        this.layoutMain.addComponent(this.iconSetComboBox);
        Button btnPrevPage = new Button(297, 3, Icons.ARROW_LEFT);
        btnPrevPage.setToolTip("Previous Page", "Go to previous page of this icon set");
        btnPrevPage.setSize(14, 14);
        btnPrevPage.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.offset > 0) {
                    --this.offset;
                }
                this.updateIcons();
            }
        });
        this.layoutMain.addComponent(btnPrevPage);
        Button btnNextPage = new Button(313, 3, Icons.ARROW_RIGHT);
        btnNextPage.setToolTip("Next Page", "Go to next page of this icon set");
        btnNextPage.setSize(14, 14);
        btnNextPage.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.offset < this.iconSetComboBox.getSelectedItem().getIcons().length / 126) {
                    ++this.offset;
                }
                this.updateIcons();
            }
        });
        this.layoutMain.addComponent(btnNextPage);
        this.updateIcons();
        this.setCurrentLayout(this.layoutMain);
    }

    private void updateIcons() {
        this.layoutContainer.clear();
        IconSet set = this.iconSetComboBox.getSelectedItem();
        for (int i = 0; i < 126 && i < set.getIcons().length - this.offset * 126; ++i) {
            Enum<? extends IIcon> anEnum = set.getIcons()[i + this.offset * 126];
            IIcon icon = (IIcon)((Object)anEnum);
            int posX = i % 18 * 18 - 1;
            int posY = i / 18 * 18 + 20;
            Button button = new Button(5 + posX, 5 + posY, icon);
            button.setToolTip("Icon", anEnum.name());
            this.layoutContainer.addComponent(button);
        }
        this.layoutContainer.updateComponents(this.layoutContainer.xPosition, this.layoutContainer.yPosition);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.offset = 0;
        this.layoutMain = null;
        this.layoutContainer = null;
        this.iconSetComboBox = null;
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }

    public static class IconSet {
        private String name;
        private Enum<? extends IIcon>[] icons;

        public IconSet(String name, Enum<? extends IIcon>[] icons) {
            this.name = name;
            this.icons = icons;
        }

        public String getName() {
            return this.name;
        }

        public Enum<? extends IIcon>[] getIcons() {
            return this.icons;
        }

        public String toString() {
            return this.name;
        }
    }
}

