/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.email;

import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.Spinner;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.app.component.TextArea;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.api.app.listener.InitListener;
import com.mrcrayfish.device.api.app.renderer.ListItemRenderer;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.email.EmailManager;
import com.mrcrayfish.device.programs.email.object.Contact;
import com.mrcrayfish.device.programs.email.object.Email;
import com.mrcrayfish.device.programs.email.task.TaskCheckEmailAccount;
import com.mrcrayfish.device.programs.email.task.TaskDeleteEmail;
import com.mrcrayfish.device.programs.email.task.TaskRegisterEmailAccount;
import com.mrcrayfish.device.programs.email.task.TaskSendEmail;
import com.mrcrayfish.device.programs.email.task.TaskUpdateInbox;
import com.mrcrayfish.device.programs.email.task.TaskViewEmail;
import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ApplicationEmail
extends Application {
    private static final ResourceLocation ENDER_MAIL_ICONS = new ResourceLocation("cdm:textures/gui/ender_mail.png");
    private static final ResourceLocation ENDER_MAIL_BACKGROUND = new ResourceLocation("cdm:textures/gui/ender_mail_background.png");
    private static final Pattern EMAIL = Pattern.compile("^([a-zA-Z0-9]{1,10})@endermail\\.com$");
    private final Color COLOR_EMAIL_CONTENT_BACKGROUND = new Color(160, 160, 160);
    private Layout layoutInit;
    private Spinner spinnerInit;
    private Label labelLoading;
    private Layout layoutMainMenu;
    private Image logo;
    private Label labelLogo;
    private Button btnRegisterAccount;
    private Layout layoutRegisterAccount;
    private Label labelEmail;
    private TextField fieldEmail;
    private Label labelDomain;
    private Button btnRegister;
    private Layout layoutInbox;
    private ItemList<Email> listEmails;
    private Button btnViewEmail;
    private Button btnNewEmail;
    private Button btnReplyEmail;
    private Button btnDeleteEmail;
    private Button btnRefresh;
    private Layout layoutNewEmail;
    private TextField fieldRecipient;
    private TextField fieldSubject;
    private TextArea textAreaMessage;
    private Button btnSendEmail;
    private Button btnCancelEmail;
    private Button btnAttachedFile;
    private Button btnRemoveAttachedFile;
    private Label labelAttachedFile;
    private Layout layoutViewEmail;
    private Label labelViewSubject;
    private Label labelSender;
    private Label labelFrom;
    private Label labelViewSubjectContent;
    private Label labelViewMessage;
    private Text textMessage;
    private Button btnCancelViewEmail;
    private Button btnSaveAttachment;
    private Label labelAttachmentName;
    private Layout layoutContacts;
    private ItemList listContacts;
    private Button btnAddContact;
    private Button btnDeleteContact;
    private Button btnCancelContact;
    private Layout layoutAddContact;
    private Label labelContactNickname;
    private TextField fieldContactNickname;
    private Label labelContactEmail;
    private TextField fieldContactEmail;
    private Button btnSaveContact;
    private Button btnCancelAddContact;
    private Layout layoutInsertContact;
    private ItemList listContacts2;
    private Button btnInsertContact;
    private Button btnCancelInsertContact;
    private String currentName;
    private File attachedFile;
    private List<Contact> contacts;

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.layoutInit = new Layout(40, 40);
        this.spinnerInit = new Spinner(14, 10);
        this.layoutInit.addComponent(this.spinnerInit);
        this.labelLoading = new Label("Loading...", 2, 26);
        this.layoutInit.addComponent(this.labelLoading);
        this.layoutMainMenu = new Layout(200, 113);
        Image image = new Image(0, 0, this.layoutMainMenu.width, this.layoutMainMenu.height, 0, 0, 640, 360, 640, 360, ENDER_MAIL_BACKGROUND);
        image.setAlpha(0.85f);
        this.layoutMainMenu.addComponent(image);
        this.logo = new Image(86, 20, 28, 28, this.info.getIconU(), this.info.getIconV(), 14, 14, 224, 224, Laptop.ICON_TEXTURES);
        this.layoutMainMenu.addComponent(this.logo);
        this.labelLogo = new Label("Ender Mail", 100, 46);
        this.labelLogo.setAlignment(2);
        this.layoutMainMenu.addComponent(this.labelLogo);
        this.btnRegisterAccount = new Button(70, 65, "Register");
        this.btnRegisterAccount.setSize(60, 16);
        this.btnRegisterAccount.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutRegisterAccount));
        this.layoutMainMenu.addComponent(this.btnRegisterAccount);
        this.setCurrentLayout(this.layoutMainMenu);
        this.layoutRegisterAccount = new Layout(200, 113);
        image = new Image(0, 0, this.layoutRegisterAccount.width, this.layoutRegisterAccount.height, 0, 0, 640, 360, 640, 360, ENDER_MAIL_BACKGROUND);
        image.setAlpha(0.85f);
        this.layoutRegisterAccount.addComponent(image);
        this.labelEmail = new Label(TextFormatting.BOLD + "Choose your email", this.layoutRegisterAccount.width / 2, 30);
        this.labelEmail.setAlignment(2);
        this.layoutRegisterAccount.addComponent(this.labelEmail);
        this.fieldEmail = new TextField(20, 50, 80);
        this.layoutRegisterAccount.addComponent(this.fieldEmail);
        this.labelDomain = new Label("@endermail.com", 105, 54);
        this.layoutRegisterAccount.addComponent(this.labelDomain);
        this.btnRegister = new Button(70, 80, "Register");
        this.btnRegister.setSize(60, 16);
        this.btnRegister.setClickListener((mouseX, mouseY, mouseButton) -> {
            int length = this.fieldEmail.getText().length();
            if (length > 0 && length <= 10) {
                TaskRegisterEmailAccount taskRegisterAccount = new TaskRegisterEmailAccount(this.fieldEmail.getText());
                taskRegisterAccount.setCallback((nbt, success) -> {
                    if (success) {
                        this.currentName = this.fieldEmail.getText();
                        this.setCurrentLayout(this.layoutInbox);
                    } else {
                        this.fieldEmail.setTextColor(Color.RED);
                    }
                });
                TaskManager.sendTask(taskRegisterAccount);
            }
        });
        this.layoutRegisterAccount.addComponent(this.btnRegister);
        this.layoutInbox = new Layout(260, 146);
        this.layoutInbox.setInitListener(new InitListener(){

            @Override
            public void onInit() {
                TaskUpdateInbox taskUpdateInbox = new TaskUpdateInbox();
                taskUpdateInbox.setCallback((nbt, success) -> {
                    ApplicationEmail.this.listEmails.removeAll();
                    for (Email email : EmailManager.INSTANCE.getInbox()) {
                        ApplicationEmail.this.listEmails.addItem(email);
                    }
                });
                TaskManager.sendTask(taskUpdateInbox);
            }
        });
        this.layoutInbox.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            mc.func_110434_K().func_110577_a(ENDER_MAIL_BACKGROUND);
            RenderUtil.drawRectWithTexture(x, y, 0.0f, 0.0f, width, height, 640.0f, 360.0f, 640, 360);
            Color temp = new Color(Laptop.getSystem().getSettings().getColorScheme().getBackgroundColor());
            Color color = new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), 150);
            Gui.func_73734_a((int)x, (int)y, (int)(x + 125), (int)(y + height), (int)color.getRGB());
            Gui.func_73734_a((int)(x + 125), (int)y, (int)(x + 126), (int)(y + height), (int)color.darker().getRGB());
            Email e = this.listEmails.getSelectedItem();
            if (e != null) {
                Gui.func_73734_a((int)(x + 130), (int)(y + 5), (int)(x + width - 5), (int)(y + 34), (int)color.getRGB());
                Gui.func_73734_a((int)(x + 130), (int)(y + 34), (int)(x + width - 5), (int)(y + 35), (int)color.darker().getRGB());
                Gui.func_73734_a((int)(x + 130), (int)(y + 35), (int)(x + width - 5), (int)(y + height - 5), (int)new Color(1.0f, 1.0f, 1.0f, 0.25f).getRGB());
                RenderUtil.drawStringClipped(e.getSubject(), x + 135, y + 10, 120, Color.WHITE.getRGB(), true);
                RenderUtil.drawStringClipped(e.getAuthor() + "@endermail.com", x + 135, y + 22, 120, Color.LIGHT_GRAY.getRGB(), false);
                Laptop.fontRenderer.func_78279_b(e.getMessage(), x + 135, y + 40, 115, Color.WHITE.getRGB());
            }
        });
        this.listEmails = new ItemList(5, 25, 116, 4);
        this.listEmails.setListItemRenderer(new ListItemRenderer<Email>(28){

            @Override
            public void render(Email e, Gui gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? Color.DARK_GRAY.getRGB() : Color.GRAY.getRGB()));
                if (!e.isRead()) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    RenderUtil.drawApplicationIcon(ApplicationEmail.this.info, x + width - 16, y + 2);
                }
                if (e.getAttachment() != null) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    int posX = x + (!e.isRead() ? -12 : 0) + width;
                    mc.func_110434_K().func_110577_a(ENDER_MAIL_ICONS);
                    RenderUtil.drawRectWithTexture(posX, y + 16, 20.0f, 10.0f, 7, 10, 13.0f, 20.0f);
                }
                RenderUtil.drawStringClipped(e.getSubject(), x + 5, y + 5, width - 20, Color.WHITE.getRGB(), false);
                RenderUtil.drawStringClipped(e.getAuthor() + "@endermail.com", x + 5, y + 17, width - 20, Color.LIGHT_GRAY.getRGB(), false);
            }
        });
        this.layoutInbox.addComponent(this.listEmails);
        this.btnViewEmail = new Button(5, 5, ENDER_MAIL_ICONS, 30, 0, 10, 10);
        this.btnViewEmail.setClickListener((mouseX, mouseY, mouseButton) -> {
            int index = this.listEmails.getSelectedIndex();
            if (index != -1) {
                TaskManager.sendTask(new TaskViewEmail(index));
                Email email = this.listEmails.getSelectedItem();
                email.setRead(true);
                this.textMessage.setText(email.getMessage());
                this.labelViewSubject.setText(email.getSubject());
                this.labelFrom.setText(email.getAuthor() + "@endermail.com");
                this.attachedFile = email.getAttachment();
                if (this.attachedFile != null) {
                    this.btnSaveAttachment.setVisible(true);
                    this.labelAttachmentName.setVisible(true);
                    this.labelAttachmentName.setText(this.attachedFile.getName());
                }
                this.setCurrentLayout(this.layoutViewEmail);
            }
        });
        this.btnViewEmail.setToolTip("View", "Opens the currently selected email");
        this.layoutInbox.addComponent(this.btnViewEmail);
        this.btnNewEmail = new Button(25, 5, ENDER_MAIL_ICONS, 0, 0, 10, 10);
        this.btnNewEmail.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutNewEmail));
        this.btnNewEmail.setToolTip("New Email", "Send an email to a player");
        this.layoutInbox.addComponent(this.btnNewEmail);
        this.btnReplyEmail = new Button(45, 5, ENDER_MAIL_ICONS, 60, 0, 10, 10);
        this.btnReplyEmail.setClickListener((mouseX, mouseY, mouseButton) -> {
            Email email = this.listEmails.getSelectedItem();
            if (email != null) {
                this.setCurrentLayout(this.layoutNewEmail);
                this.fieldRecipient.setText(email.getAuthor() + "@endermail.com");
                this.fieldSubject.setText("RE: " + email.getSubject());
            }
        });
        this.btnReplyEmail.setToolTip("Reply", "Reply to the currently selected email");
        this.layoutInbox.addComponent(this.btnReplyEmail);
        this.btnDeleteEmail = new Button(65, 5, ENDER_MAIL_ICONS, 10, 0, 10, 10);
        this.btnDeleteEmail.setClickListener((mouseX, mouseY, mouseButton) -> {
            int index = this.listEmails.getSelectedIndex();
            if (index != -1) {
                TaskDeleteEmail taskDeleteEmail = new TaskDeleteEmail(index);
                taskDeleteEmail.setCallback((nbt, success) -> {
                    this.listEmails.removeItem(index);
                    EmailManager.INSTANCE.getInbox().remove(index);
                });
                TaskManager.sendTask(taskDeleteEmail);
            }
        });
        this.btnDeleteEmail.setToolTip("Trash Email", "Deletes the currently select email");
        this.layoutInbox.addComponent(this.btnDeleteEmail);
        this.btnRefresh = new Button(85, 5, ENDER_MAIL_ICONS, 20, 0, 10, 10);
        this.btnRefresh.setClickListener((mouseX, mouseY, mouseButton) -> {
            TaskUpdateInbox taskUpdateInbox = new TaskUpdateInbox();
            taskUpdateInbox.setCallback((nbt, success) -> {
                this.listEmails.removeAll();
                for (Email email : EmailManager.INSTANCE.getInbox()) {
                    this.listEmails.addItem(email);
                }
            });
            TaskManager.sendTask(taskUpdateInbox);
        });
        this.btnRefresh.setToolTip("Refresh Inbox", "Checks for any new emails");
        this.layoutInbox.addComponent(this.btnRefresh);
        Button btnSettings = new Button(105, 5, Icons.WRENCH);
        this.layoutInbox.addComponent(btnSettings);
        this.layoutNewEmail = new Layout(231, 148);
        this.layoutNewEmail.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            if (this.attachedFile != null) {
                AppInfo info = ApplicationManager.getApplication(this.attachedFile.getOpeningApp());
                RenderUtil.drawApplicationIcon(info, x + 46, y + 130);
            }
        });
        this.fieldRecipient = new TextField(26, 5, 200);
        this.fieldRecipient.setPlaceholder("To");
        this.layoutNewEmail.addComponent(this.fieldRecipient);
        this.fieldSubject = new TextField(26, 23, 200);
        this.fieldSubject.setPlaceholder("Subject");
        this.layoutNewEmail.addComponent(this.fieldSubject);
        this.textAreaMessage = new TextArea(26, 41, 200, 85);
        this.textAreaMessage.setPlaceholder("Message");
        this.layoutNewEmail.addComponent(this.textAreaMessage);
        this.btnSendEmail = new Button(5, 5, ENDER_MAIL_ICONS, 50, 0, 10, 10);
        this.btnSendEmail.setClickListener((mouseX, mouseY, mouseButton) -> {
            Matcher matcher = EMAIL.matcher(this.fieldRecipient.getText());
            if (!matcher.matches()) {
                return;
            }
            Email email = new Email(this.fieldSubject.getText(), this.textAreaMessage.getText(), this.attachedFile);
            TaskSendEmail taskSendEmail = new TaskSendEmail(email, matcher.group(1));
            taskSendEmail.setCallback((nbt, success) -> {
                if (success) {
                    this.setCurrentLayout(this.layoutInbox);
                    this.textAreaMessage.clear();
                    this.fieldSubject.clear();
                    this.fieldRecipient.clear();
                    this.resetAttachedFile();
                }
            });
            TaskManager.sendTask(taskSendEmail);
        });
        this.btnSendEmail.setToolTip("Send", "Send email to recipient");
        this.layoutNewEmail.addComponent(this.btnSendEmail);
        this.btnCancelEmail = new Button(5, 25, ENDER_MAIL_ICONS, 40, 0, 10, 10);
        this.btnCancelEmail.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.setCurrentLayout(this.layoutInbox);
            this.textAreaMessage.clear();
            this.fieldSubject.clear();
            this.fieldRecipient.clear();
            this.resetAttachedFile();
        });
        this.btnCancelEmail.setToolTip("Cancel", "Go back to Inbox");
        this.layoutNewEmail.addComponent(this.btnCancelEmail);
        this.btnAttachedFile = new Button(26, 129, ENDER_MAIL_ICONS, 70, 0, 10, 10);
        this.btnAttachedFile.setToolTip("Attach File", "Select a file from computer to attach to this email");
        this.btnAttachedFile.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                Dialog.OpenFile dialog = new Dialog.OpenFile(this);
                dialog.setResponseHandler((success, file) -> {
                    if (!file.isFolder()) {
                        this.attachedFile = file.copy();
                        this.labelAttachedFile.setText(file.getName());
                        this.labelAttachedFile.left += 16;
                        this.labelAttachedFile.xPosition += 16;
                        this.btnAttachedFile.setVisible(false);
                        this.btnRemoveAttachedFile.setVisible(true);
                        dialog.close();
                    } else {
                        this.openDialog(new Dialog.Message("Attachment must be a file!"));
                    }
                    return false;
                });
                this.openDialog(dialog);
            }
        });
        this.layoutNewEmail.addComponent(this.btnAttachedFile);
        this.btnRemoveAttachedFile = new Button(26, 129, ENDER_MAIL_ICONS, 40, 0, 10, 10);
        this.btnRemoveAttachedFile.setToolTip("Remove Attachment", "Delete the attached file from this email");
        this.btnRemoveAttachedFile.setVisible(false);
        this.btnRemoveAttachedFile.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.resetAttachedFile();
            }
        });
        this.layoutNewEmail.addComponent(this.btnRemoveAttachedFile);
        this.labelAttachedFile = new Label("No file attached", 46, 133);
        this.layoutNewEmail.addComponent(this.labelAttachedFile);
        this.layoutViewEmail = new Layout(240, 156);
        this.layoutViewEmail.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Gui.func_73734_a((int)x, (int)(y + 22), (int)(x + this.layoutViewEmail.width), (int)(y + 50), (int)Color.GRAY.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 22), (int)(x + this.layoutViewEmail.width), (int)(y + 23), (int)Color.DARK_GRAY.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 49), (int)(x + this.layoutViewEmail.width), (int)(y + 50), (int)Color.DARK_GRAY.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 50), (int)(x + this.layoutViewEmail.width), (int)(y + 156), (int)this.COLOR_EMAIL_CONTENT_BACKGROUND.getRGB());
            if (this.attachedFile != null) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                AppInfo info = ApplicationManager.getApplication(this.attachedFile.getOpeningApp());
                RenderUtil.drawApplicationIcon(info, x + 204, y + 4);
            }
        });
        this.labelViewSubject = new Label("Subject", 5, 26);
        this.labelViewSubject.setTextColor(new Color(255, 170, 0));
        this.layoutViewEmail.addComponent(this.labelViewSubject);
        this.labelFrom = new Label("From", 5, 38);
        this.layoutViewEmail.addComponent(this.labelFrom);
        this.btnCancelViewEmail = new Button(5, 3, ENDER_MAIL_ICONS, 40, 0, 10, 10);
        this.btnCancelViewEmail.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.attachedFile = null;
                this.btnSaveAttachment.setVisible(false);
                this.labelAttachmentName.setVisible(false);
                this.setCurrentLayout(this.layoutInbox);
            }
        });
        this.btnCancelViewEmail.setToolTip("Cancel", "Go back to Inbox");
        this.layoutViewEmail.addComponent(this.btnCancelViewEmail);
        this.textMessage = new Text("Hallo", 5, 54, 230);
        this.textMessage.setShadow(false);
        this.layoutViewEmail.addComponent(this.textMessage);
        this.btnSaveAttachment = new Button(219, 3, ENDER_MAIL_ICONS, 80, 0, 10, 10);
        this.btnSaveAttachment.setToolTip("Save Attachment", "Save the file attached to this email");
        this.btnSaveAttachment.setVisible(false);
        this.btnSaveAttachment.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && this.attachedFile != null) {
                Dialog.SaveFile dialog = new Dialog.SaveFile((Application)this, this.attachedFile);
                this.openDialog(dialog);
            }
        });
        this.layoutViewEmail.addComponent(this.btnSaveAttachment);
        this.labelAttachmentName = new Label("", 200, 7);
        this.labelAttachmentName.setVisible(false);
        this.labelAttachmentName.setAlignment(1);
        this.layoutViewEmail.addComponent(this.labelAttachmentName);
        this.setCurrentLayout(this.layoutInit);
        TaskCheckEmailAccount taskCheckAccount = new TaskCheckEmailAccount();
        taskCheckAccount.setCallback((nbt, success) -> {
            if (success) {
                this.currentName = nbt.func_74779_i("Name");
                this.listEmails.removeAll();
                for (Email email : EmailManager.INSTANCE.getInbox()) {
                    this.listEmails.addItem(email);
                }
                this.setCurrentLayout(this.layoutInbox);
            } else {
                this.btnRegisterAccount.setVisible(true);
                this.setCurrentLayout(this.layoutMainMenu);
            }
        });
        TaskManager.sendTask(taskCheckAccount);
    }

    private void resetAttachedFile() {
        if (this.attachedFile != null) {
            this.labelAttachedFile.setText("No file attached");
            this.labelAttachedFile.left -= 16;
            this.labelAttachedFile.xPosition -= 16;
            this.btnRemoveAttachedFile.setVisible(false);
            this.btnAttachedFile.setVisible(true);
            this.attachedFile = null;
        }
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }

    @Override
    public String getWindowTitle() {
        if (this.getCurrentLayout() == this.layoutInbox) {
            return "Inbox: " + this.currentName + "@endermail.com";
        }
        if (this.getCurrentLayout() == this.layoutContacts) {
            return "Contacts";
        }
        return this.info.getName();
    }

    @Override
    public void onClose() {
        super.onClose();
        this.attachedFile = null;
    }
}

