/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system.layout;

import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.api.app.renderer.ListItemRenderer;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.system.ApplicationAppStore;
import com.mrcrayfish.device.programs.system.layout.LayoutAppPage;
import com.mrcrayfish.device.programs.system.layout.StandardLayout;
import com.mrcrayfish.device.programs.system.object.LocalEntry;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class LayoutSearchApps
extends StandardLayout {
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private long lastClick = 0L;
    private ApplicationAppStore appStore;

    public LayoutSearchApps(ApplicationAppStore appStore, Layout previous) {
        super("Search", 250, 150, appStore, previous);
        this.appStore = appStore;
    }

    @Override
    public void init() {
        super.init();
        final ItemList<AppInfo> itemListResults = new ItemList<AppInfo>(5, 48, 240, 5, true);
        itemListResults.setItems(ApplicationManager.getAvailableApplications());
        itemListResults.sortBy(Comparator.comparing(AppInfo::getName));
        itemListResults.setListItemRenderer(new ListItemRenderer<AppInfo>(18){

            @Override
            public void render(AppInfo info, Gui gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? ITEM_SELECTED.getRGB() : ITEM_BACKGROUND.getRGB()));
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.drawApplicationIcon(info, x + 2, y + 2);
                RenderUtil.drawStringClipped(info.getName() + TextFormatting.GRAY + " - " + TextFormatting.DARK_GRAY + info.getDescription(), x + 20, y + 5, itemListResults.getWidth() - 22, Color.WHITE.getRGB(), false);
            }
        });
        itemListResults.setItemClickListener((info, index, mouseButton) -> {
            if (mouseButton == 0) {
                if (System.currentTimeMillis() - this.lastClick <= 200L) {
                    this.openApplication((AppInfo)info);
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
        });
        this.addComponent(itemListResults);
        TextField textFieldSearch = new TextField(5, 26, 240);
        textFieldSearch.setIcon(Icons.SEARCH);
        textFieldSearch.setPlaceholder("...");
        textFieldSearch.setKeyListener(c -> {
            Predicate<AppInfo> FILTERED = info -> StringUtils.containsIgnoreCase((CharSequence)info.getName(), (CharSequence)textFieldSearch.getText()) || StringUtils.containsIgnoreCase((CharSequence)info.getDescription(), (CharSequence)textFieldSearch.getText());
            List filteredItems = ApplicationManager.getAvailableApplications().stream().filter(FILTERED).collect(Collectors.toList());
            itemListResults.setItems(filteredItems);
            return false;
        });
        this.addComponent(textFieldSearch);
    }

    private void openApplication(AppInfo info) {
        LayoutAppPage layout = new LayoutAppPage(this.appStore.getLaptop(), new LocalEntry(info), this.appStore);
        this.app.setCurrentLayout(layout);
        Button btnPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        btnPrevious.setClickListener((mouseX1, mouseY1, mouseButton1) -> this.app.setCurrentLayout(this));
        layout.addComponent(btnPrevious);
    }
}

