/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.tileentity;

import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import com.mrcrayfish.device.util.TileEntityUtil;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaptop
extends TileEntityNetworkDevice.Colored {
    private static final int OPENED_ANGLE = 102;
    private boolean open = false;
    private NBTTagCompound applicationData;
    private NBTTagCompound systemData;
    private FileSystem fileSystem;
    @SideOnly(value=Side.CLIENT)
    private int rotation;
    @SideOnly(value=Side.CLIENT)
    private int prevRotation;
    @SideOnly(value=Side.CLIENT)
    private EnumDyeColor externalDriveColor;

    @Override
    public String getDeviceName() {
        return "Laptop";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.prevRotation = this.rotation;
            if (!this.open) {
                if (this.rotation > 0) {
                    this.rotation = (int)((float)this.rotation - 10.0f);
                }
            } else if (this.rotation < 102) {
                this.rotation = (int)((float)this.rotation + 10.0f);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("open")) {
            this.open = compound.func_74767_n("open");
        }
        if (compound.func_150297_b("system_data", 10)) {
            this.systemData = compound.func_74775_l("system_data");
        }
        if (compound.func_150297_b("application_data", 10)) {
            this.applicationData = compound.func_74775_l("application_data");
        }
        if (compound.func_74764_b("file_system")) {
            this.fileSystem = new FileSystem(this, compound.func_74775_l("file_system"));
        }
        if (compound.func_150297_b("external_drive_color", 1)) {
            this.externalDriveColor = null;
            if (compound.func_74771_c("external_drive_color") != -1) {
                this.externalDriveColor = EnumDyeColor.func_176764_b((int)compound.func_74771_c("external_drive_color"));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("open", this.open);
        if (this.systemData != null) {
            compound.func_74782_a("system_data", (NBTBase)this.systemData);
        }
        if (this.applicationData != null) {
            compound.func_74782_a("application_data", (NBTBase)this.applicationData);
        }
        if (this.fileSystem != null) {
            compound.func_74782_a("file_system", (NBTBase)this.fileSystem.toTag());
        }
        return compound;
    }

    @Override
    public NBTTagCompound writeSyncTag() {
        NBTTagCompound tag = super.writeSyncTag();
        tag.func_74757_a("open", this.open);
        tag.func_74782_a("system_data", (NBTBase)this.getSystemData());
        if (this.getFileSystem().getAttachedDrive() != null) {
            tag.func_74774_a("external_drive_color", (byte)this.getFileSystem().getAttachedDriveColor().func_176765_a());
        } else {
            tag.func_74774_a("external_drive_color", (byte)-1);
        }
        return tag;
    }

    public double func_145833_n() {
        return 16384.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void openClose() {
        this.open = !this.open;
        this.pipeline.func_74757_a("open", this.open);
        this.sync();
    }

    public boolean isOpen() {
        return this.open;
    }

    public NBTTagCompound getApplicationData() {
        return this.applicationData != null ? this.applicationData : new NBTTagCompound();
    }

    public NBTTagCompound getSystemData() {
        if (this.systemData == null) {
            this.systemData = new NBTTagCompound();
        }
        return this.systemData;
    }

    public FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            this.fileSystem = new FileSystem(this, new NBTTagCompound());
        }
        return this.fileSystem;
    }

    public void setApplicationData(String appId, NBTTagCompound applicationData) {
        this.applicationData = applicationData;
        this.func_70296_d();
        TileEntityUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void setSystemData(NBTTagCompound systemData) {
        this.systemData = systemData;
        this.func_70296_d();
        TileEntityUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public float getScreenAngle(float partialTicks) {
        return -102.0f * (((float)this.prevRotation + (float)(this.rotation - this.prevRotation) * partialTicks) / 102.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isExternalDriveAttached() {
        return this.externalDriveColor != null;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getExternalDriveColor() {
        return this.externalDriveColor;
    }
}

