/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import superhb.arcademod.client.blocks.IBlockVariant;
import superhb.arcademod.client.tileentity.TileEntityPlushie;
import superhb.arcademod.util.EnumMob;
import superhb.arcademod.util.EnumRotation;

public class BlockPlushie
extends Block
implements IBlockVariant {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final PropertyEnum ROTATION = PropertyEnum.func_177709_a((String)"rotation", EnumRotation.class);
    public static final PropertyEnum MOB = PropertyEnum.func_177709_a((String)"mob", EnumMob.class);
    private static final AxisAlignedBB[][] boundingBox = new AxisAlignedBB[][]{{new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.8125, 0.6875)}, {new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875)}};
    private static final SoundEvent[] mobSounds = new SoundEvent[]{SoundEvents.field_187570_aq, SoundEvents.field_187697_dL};

    public BlockPlushie(Material material) {
        super(material);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOB, (Comparable)((Object)EnumMob.CREEPER)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPlushie();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        TileEntityPlushie tile = world.func_175625_s(pos) instanceof TileEntityPlushie ? (TileEntityPlushie)world.func_175625_s(pos) : null;
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack stack = new ItemStack((Block)this);
        compound.func_74768_a("Mob", tile.getMobID());
        stack.func_77982_d(compound);
        if (tile != null) {
            drops.add(stack);
        }
        return drops;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boundingBox[0][0];
    }

    private AxisAlignedBB getBoundingBox(int mob, int rotation) {
        return boundingBox[mob][rotation];
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPlushie) {
            TileEntityPlushie plushie = (TileEntityPlushie)tile;
            return this.getBoundingBox(plushie.getMobID(), 0).func_186670_a(pos);
        }
        return state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack stack = new ItemStack((Block)this);
        compound.func_74768_a("Mob", 0);
        stack.func_77982_d(compound);
        if (tile instanceof TileEntityPlushie) {
            TileEntityPlushie plushie = (TileEntityPlushie)tile;
            compound.func_74768_a("Mob", plushie.getMobID());
            stack.func_77982_d(compound);
            return stack;
        }
        return stack;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPlushie) {
            TileEntityPlushie plushie = (TileEntityPlushie)tile;
            return state.func_177226_a((IProperty)MOB, (Comparable)((Object)EnumMob.getValue(plushie.getMobID())));
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MOB});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPlushie) {
            TileEntityPlushie plushie = (TileEntityPlushie)tile;
            if (world.field_72995_K) {
                world.func_184133_a(player, pos, mobSounds[plushie.getMobID()], SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    public String getVariantName(ItemStack stack) {
        if (stack.func_77942_o()) {
            return EnumMob.getName(stack.func_77978_p().func_74762_e("Mob"));
        }
        return EnumMob.getName(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumMob.values().length; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            ItemStack stack = new ItemStack((Block)this);
            compound.func_74768_a("Mob", i);
            stack.func_77982_d(compound);
            list.add((Object)stack);
        }
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventId, int eventParam) {
        super.func_189539_a(state, world, pos, eventId, eventParam);
        TileEntity tile = world.func_175625_s(pos);
        return tile == null ? false : tile.func_145842_c(eventId, eventParam);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

