/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.gui;

import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import superhb.arcademod.api.gui.GuiArcade;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.util.KeyHandler;

public class GuiSnake
extends GuiArcade {
    private static final ResourceLocation texture = new ResourceLocation("arcademod:textures/gui/snake.png");
    private int snakePosX = 0;
    private int snakePosY = 0;
    private int pointPosX = 0;
    private int pointPosY = 0;
    private int[] tailX = new int[200];
    private int[] tailY = new int[200];
    private int direction = 0;
    private int difficulty = 0;
    private int tail = 0;
    private int score = 0;
    private boolean start = true;
    private boolean gameOver = false;
    private int prevTick = 0;
    private int tick = 4;
    private static final int GUI_X = 150;
    private static final int GUI_Y = 207;
    private static final int ARROW_X = 7;
    private static final int ARROW_Y = 11;
    private static final int SNAKE = 5;
    private static final int POINT = 3;

    public GuiSnake(World world, TileEntityArcade tileEntity, EntityPlayer player) {
        super(world, tileEntity, null, player);
        this.func_183500_a(150, 207);
        this.setButtonPos(75 - this.buttonWidth / 2, 175);
        this.setTexture(texture);
        this.setStartMenu(0);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.inMenu) {
            if (this.menu == 3 && this.tickCounter - this.prevTick >= 60) {
                this.prevTick = this.tickCounter;
                this.checkMenuAfterGameOver();
                this.direction = 0;
                this.start = true;
                this.tail = 0;
            }
        } else if (this.tickCounter - this.prevTick >= this.tick) {
            int i;
            this.prevTick = this.tickCounter;
            int preX = this.tailX[0];
            int preY = this.tailY[0];
            if (this.start) {
                this.pointPosX = this.getWorld().field_73012_v.nextInt(25);
                this.pointPosY = this.getWorld().field_73012_v.nextInt(36);
                this.start = false;
            }
            if (this.direction == 0) {
                this.snakePosX = 13;
                this.snakePosY = 18;
            } else if (this.direction == 1) {
                this.tailX[0] = this.snakePosX;
                this.tailY[0] = this.snakePosY--;
            } else if (this.direction == 2) {
                this.tailX[0] = this.snakePosX;
                this.tailY[0] = this.snakePosY++;
            } else if (this.direction == 3) {
                this.tailX[0] = this.snakePosX--;
                this.tailY[0] = this.snakePosY;
            } else if (this.direction == 4) {
                this.tailX[0] = this.snakePosX++;
                this.tailY[0] = this.snakePosY;
            }
            if (this.snakePosX < 0 || this.snakePosX > 25 || this.snakePosY < 0 || this.snakePosY > 36) {
                this.direction = -1;
                this.gameOver = true;
            }
            for (i = 0; i < this.tail; ++i) {
                if (i >= this.tailX.length || this.tailX[i] != this.snakePosX || this.tailY[i] != this.snakePosY) continue;
                this.direction = -1;
                this.gameOver = true;
            }
            if (this.snakePosX == this.pointPosX && this.snakePosY == this.pointPosY) {
                ++this.tail;
                this.pointPosX = this.getWorld().field_73012_v.nextInt(25);
                this.pointPosY = this.getWorld().field_73012_v.nextInt(36);
                for (i = 0; i < this.tail; ++i) {
                    if (i >= this.tailX.length || (this.pointPosX != this.tailX[i] || this.pointPosY != this.tailY[i]) && (this.pointPosX != this.snakePosX || this.pointPosY != this.snakePosY)) continue;
                    this.pointPosX = this.getWorld().field_73012_v.nextInt(25);
                    this.pointPosY = this.getWorld().field_73012_v.nextInt(36);
                }
            }
            for (i = 1; i < this.tail; ++i) {
                if (i >= this.tailX.length) continue;
                int pre2X = this.tailX[i];
                int pre2Y = this.tailY[i];
                this.tailX[i] = preX;
                this.tailY[i] = preY;
                preX = pre2X;
                preY = pre2Y;
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int minX = this.field_146294_l / 2 - 75 + 10;
        int minY = this.field_146295_m / 2 - 103 + 10;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.inMenu) {
            int startWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]));
            int difficultyWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:difficulty.locale", (Object[])new Object[0]));
            int controlWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]));
            int easyWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:difficulty.easy.locale", (Object[])new Object[0]));
            int mediumWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:difficulty.medium.locale", (Object[])new Object[0]));
            int hardWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:difficulty.hard.locale", (Object[])new Object[0]));
            int extremeWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:difficulty.extreme.locale", (Object[])new Object[0]));
            block0 : switch (this.menu) {
                case 0: {
                    int titleWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"game.arcademod:snake.name", (Object[])new Object[0]));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"game.arcademod:snake.name", (Object[])new Object[0]), this.field_146294_l / 2 - titleWidth / 2, this.field_146295_m / 2 - 103 + 11, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.field_146294_l / 2 - startWidth / 2, this.field_146295_m / 2, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:difficulty.locale", (Object[])new Object[0]), this.field_146294_l / 2 - difficultyWidth / 2, this.field_146295_m / 2 + 10, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.field_146294_l / 2 - controlWidth / 2, this.field_146295_m / 2 + 20, 0xFFFFFF);
                    switch (this.menuOption) {
                        case 0: {
                            this.field_146297_k.func_110434_K().func_110577_a(texture);
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2, 0, 207, 7, 11);
                            break block0;
                        }
                        case 1: {
                            this.field_146297_k.func_110434_K().func_110577_a(texture);
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2 + 10, 0, 207, 7, 11);
                            break block0;
                        }
                        case 2: {
                            this.field_146297_k.func_110434_K().func_110577_a(texture);
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2 + 20, 0, 207, 7, 11);
                        }
                    }
                    break;
                }
                case 1: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:difficulty.locale", (Object[])new Object[0]), this.field_146294_l / 2 - difficultyWidth / 2, this.field_146295_m / 2 - 103 + 11, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:difficulty.easy.locale", (Object[])new Object[0]), this.field_146294_l / 2 - easyWidth / 2, this.field_146295_m / 2, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:difficulty.medium.locale", (Object[])new Object[0]), this.field_146294_l / 2 - mediumWidth / 2, this.field_146295_m / 2 + 10, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:difficulty.hard.locale", (Object[])new Object[0]), this.field_146294_l / 2 - hardWidth / 2, this.field_146295_m / 2 + 20, 0xFFFFFF);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:difficulty.extreme.locale", (Object[])new Object[0]), this.field_146294_l / 2 - extremeWidth / 2, this.field_146295_m / 2 + 30, 0xFFFFFF);
                    this.field_146297_k.func_110434_K().func_110577_a(texture);
                    switch (this.difficulty) {
                        case 0: {
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2, 0, 207, 7, 11);
                            break block0;
                        }
                        case 1: {
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2 + 10, 0, 207, 7, 11);
                            break block0;
                        }
                        case 2: {
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2 + 20, 0, 207, 7, 11);
                            break block0;
                        }
                        case 3: {
                            this.func_73729_b(minX + 30, this.field_146295_m / 2 - 2 + 30, 0, 207, 7, 11);
                        }
                    }
                    break;
                }
                case 2: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.field_146294_l / 2 - controlWidth / 2, this.field_146295_m / 2 - 103 + 11, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.up.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:up.name", (Object[])new Object[0]), this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 10, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.down.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:down.name", (Object[])new Object[0]), this.field_146294_l / 2 - 40, this.field_146295_m / 2, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:left.name", (Object[])new Object[0]), this.field_146294_l / 2 - 40, this.field_146295_m / 2 + 10, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.right.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:right.name", (Object[])new Object[0]), this.field_146294_l / 2 - 40, this.field_146295_m / 2 + 20, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.select.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:select.name", (Object[])new Object[0]), this.field_146294_l / 2 - 40, this.field_146295_m / 2 + 30, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.field_146294_l / 2 - 75 + 12, this.field_146295_m / 2 + 103 - 20, Color.white.getRGB());
                    break;
                }
                case 3: {
                    int overWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]), this.field_146294_l / 2 - overWidth / 2, this.field_146295_m / 2 - 20, Color.white.getRGB());
                    int scoreWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.tail);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.tail, this.field_146294_l / 2 - scoreWidth / 2, this.field_146295_m / 2 - 10, Color.white.getRGB());
                    break;
                }
            }
        } else {
            if (this.gameOver) {
                this.menu = 3;
                this.score = this.tail;
                this.inMenu = true;
                this.gameOver = false;
                this.giveReward(ArcadeItems.TICKET, this.score / 10);
            }
            this.func_73729_b(minX + this.snakePosX * 5, minY + this.snakePosY * 5, 7, 207, 5, 5);
            this.func_73729_b(minX + 1 + this.pointPosX * 5, minY + 1 + this.pointPosY * 5, 12, 207, 3, 3);
            for (int i = 1; i <= this.tail; ++i) {
                if (i >= this.tailX.length) continue;
                this.func_73729_b(minX + this.tailX[i - 1] * 5, minY + this.tailY[i - 1] * 5, 7, 207, 5, 5);
            }
            int scoreWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.tail);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.tail, this.field_146294_l / 2 - scoreWidth / 2, this.field_146295_m / 2 + 93, 0x404040);
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == KeyHandler.up.func_151463_i()) {
            if (this.inMenu) {
                if (this.menu == 0) {
                    this.menuOption = this.menuOption == 0 ? 2 : --this.menuOption;
                } else if (this.menu == 1) {
                    this.difficulty = this.difficulty == 0 ? 3 : --this.difficulty;
                }
            } else {
                this.direction = this.tail > 0 ? (this.direction != 2 ? 1 : 2) : 1;
            }
        }
        if (keyCode == KeyHandler.down.func_151463_i()) {
            if (this.inMenu) {
                if (this.menu == 0) {
                    this.menuOption = this.menuOption == 2 ? 0 : ++this.menuOption;
                } else if (this.menu == 1) {
                    this.difficulty = this.difficulty == 3 ? 0 : ++this.difficulty;
                }
            } else {
                this.direction = this.tail > 0 ? (this.direction != 1 ? 2 : 1) : 2;
            }
        }
        if (keyCode == KeyHandler.left.func_151463_i()) {
            if (this.inMenu) {
                if (this.menu == 2) {
                    this.menu = 0;
                }
            } else {
                this.direction = this.tail > 0 ? (this.direction != 4 ? 3 : 4) : 3;
            }
        }
        if (keyCode == KeyHandler.right.func_151463_i() && !this.inMenu) {
            this.direction = this.tail > 0 ? (this.direction != 3 ? 4 : 3) : 4;
        }
        if (keyCode == KeyHandler.select.func_151463_i() && this.inMenu) {
            if (this.menu == 0) {
                switch (this.menuOption) {
                    case 0: {
                        this.inMenu = false;
                        this.canGetCoinBack = false;
                        break;
                    }
                    case 1: {
                        this.menu = 1;
                        break;
                    }
                    case 2: {
                        this.menu = 2;
                    }
                }
            } else if (this.menu == 1) {
                switch (this.difficulty) {
                    case 0: {
                        this.tick = 4;
                        break;
                    }
                    case 1: {
                        this.tick = 3;
                        break;
                    }
                    case 2: {
                        this.tick = 2;
                        break;
                    }
                    case 3: {
                        this.tick = 1;
                    }
                }
                this.menu = 0;
            }
        }
        if (keyCode == 1 && !this.inMenu) {
            this.giveReward(ArcadeItems.TICKET, this.score / 10);
        }
        super.func_73869_a(typedChar, keyCode);
    }
}

