/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import superhb.arcademod.Arcade;
import superhb.arcademod.network.ClientBuyMessage;
import superhb.arcademod.util.ArcadePacketHandler;

public class ServerBuyMessage
implements IMessage {
    private ItemStack stack;
    private ItemStack currency;
    private int cost;

    public ServerBuyMessage() {
    }

    public ServerBuyMessage(ItemStack stack, ItemStack currency, int amount, int cost) {
        this.stack = stack;
        this.stack.func_190920_e(amount);
        this.currency = currency;
        this.cost = cost;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.currency);
        buf.writeInt(this.cost);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.currency = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.cost = buf.readInt();
        }
        catch (Exception e) {
            Arcade.logger.info("Error: " + e);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStack getCurrency() {
        return this.currency;
    }

    public int getCost() {
        return this.cost;
    }

    public static class Handler
    implements IMessageHandler<ServerBuyMessage, IMessage> {
        public IMessage onMessage(ServerBuyMessage message, MessageContext context) {
            WorldServer thread = (WorldServer)context.getServerHandler().field_147369_b.field_70170_p;
            thread.func_152344_a(() -> {
                ArrayList<int[]> slotIndexes = new ArrayList<int[]>();
                int totalCurrency = 0;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                if (player.field_71071_by.func_70431_c(message.currency)) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        if (!player.field_71071_by.func_70301_a(i).func_77973_b().equals(message.getCurrency().func_77973_b())) continue;
                        totalCurrency += player.field_71071_by.func_70301_a(i).func_190916_E();
                        slotIndexes.add(new int[]{i, player.field_71071_by.func_70301_a(i).func_190916_E()});
                    }
                    if (totalCurrency < message.getCost()) {
                        ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientBuyMessage(false), player);
                    } else if (totalCurrency == message.getCost()) {
                        for (int[] i : slotIndexes) {
                            player.field_71071_by.func_70304_b(i[0]);
                        }
                        player.field_71071_by.func_70441_a(message.getStack());
                        ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientBuyMessage(true), player);
                    } else if (totalCurrency > message.getCost()) {
                        int useSlot;
                        if (message.getCost() < 64) {
                            useSlot = 0;
                            for (int i = 0; i < slotIndexes.size(); ++i) {
                                if (((int[])slotIndexes.get(i))[1] < message.getCost()) continue;
                                useSlot = ((int[])slotIndexes.get(i))[0];
                            }
                            player.field_71071_by.func_70298_a(useSlot, message.cost);
                            player.field_71071_by.func_70441_a(message.getStack());
                        } else if (message.getCost() == 64) {
                            useSlot = 0;
                            for (int i = 0; i < slotIndexes.size(); ++i) {
                                if (((int[])slotIndexes.get(i))[1] < message.getCost()) continue;
                                useSlot = ((int[])slotIndexes.get(i))[0];
                            }
                            player.field_71071_by.func_70304_b(useSlot);
                            player.field_71071_by.func_70441_a(message.getStack());
                        } else if (message.getCost() > 64) {
                            int i;
                            int stacks;
                            int j = 0;
                            float stacksf = (float)message.getCost() / 64.0f;
                            float remainder = (stacksf - (float)(stacks = message.getCost() / 64)) * 64.0f;
                            int[] useSlot2 = remainder == 0.0f ? new int[stacks] : new int[stacks + 1];
                            for (i = 0; i < slotIndexes.size(); ++i) {
                                if (j >= useSlot2.length) continue;
                                if (((int[])slotIndexes.get(i))[1] == 64) {
                                    useSlot2[j] = ((int[])slotIndexes.get(i))[0];
                                } else if (remainder > 0.0f && (float)((int[])slotIndexes.get(i))[1] >= remainder) {
                                    useSlot2[j] = ((int[])slotIndexes.get(i))[0];
                                }
                                ++j;
                            }
                            for (i = 0; i < useSlot2.length; ++i) {
                                if (remainder == 0.0f) {
                                    player.field_71071_by.func_70298_a(useSlot2[i], 64);
                                    continue;
                                }
                                if (i < useSlot2.length - 1) {
                                    player.field_71071_by.func_70298_a(useSlot2[i], 64);
                                    continue;
                                }
                                if (i >= useSlot2.length) continue;
                                player.field_71071_by.func_70298_a(useSlot2[i], (int)remainder);
                            }
                            player.field_71071_by.func_70441_a(message.getStack());
                        }
                        ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientBuyMessage(true), player);
                    }
                } else {
                    ArcadePacketHandler.INSTANCE.sendTo((IMessage)new ClientBuyMessage(false), player);
                }
            });
            return null;
        }
    }
}

