/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.HashMap;
import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFuncBlock;
import mod.lucky.drop.func.DropFuncCommand;
import mod.lucky.drop.func.DropFuncDifficulty;
import mod.lucky.drop.func.DropFuncEffect;
import mod.lucky.drop.func.DropFuncEntity;
import mod.lucky.drop.func.DropFuncExplosion;
import mod.lucky.drop.func.DropFuncFill;
import mod.lucky.drop.func.DropFuncItem;
import mod.lucky.drop.func.DropFuncMessage;
import mod.lucky.drop.func.DropFuncNothing;
import mod.lucky.drop.func.DropFuncParticle;
import mod.lucky.drop.func.DropFuncSound;
import mod.lucky.drop.func.DropFuncStructure;
import mod.lucky.drop.func.DropFuncTime;
import mod.lucky.drop.func.DropProcessData;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DropFunction {
    private static HashMap<String, DropFunction> dropFunctions = new HashMap();

    public abstract void process(DropProcessData var1);

    public abstract String getType();

    public void registerProperties() {
    }

    public static void registerGlobalProperties() {
        DropProperties.setDefaultProperty("all", "type", String.class, "item");
        DropProperties.setDefaultProperty("all", "ID", String.class, "");
        DropProperties.setDefaultProperty("all", "damage", Integer.class, 0);
        DropProperties.setDefaultProperty("all", "amount", Integer.class, 1);
        DropProperties.setDefaultProperty("all", "reinitialize", Boolean.class, false);
        DropProperties.setDefaultProperty("all", "postDelayInit", Boolean.class, true);
        DropProperties.setDefaultProperty("all", "delay", Float.class, 0);
        DropProperties.setDefaultProperty("all", "posX", Float.class, 0);
        DropProperties.setDefaultProperty("all", "posY", Float.class, 0);
        DropProperties.setDefaultProperty("all", "posZ", Float.class, 0);
        DropProperties.setDefaultProperty("all", "pos", String.class, "(0,0,0)");
        DropProperties.setDefaultProperty("all", "pos2X", Float.class, 0);
        DropProperties.setDefaultProperty("all", "pos2Y", Float.class, 0);
        DropProperties.setDefaultProperty("all", "pos2Z", Float.class, 0);
        DropProperties.setDefaultProperty("all", "pos2", String.class, "(0,0,0)");
        DropProperties.setDefaultProperty("all", "posOffsetX", Float.class, 0);
        DropProperties.setDefaultProperty("all", "posOffsetY", Float.class, 0);
        DropProperties.setDefaultProperty("all", "posOffsetZ", Float.class, 0);
        DropProperties.setDefaultProperty("all", "posOffset", String.class, "(0,0,0)");
        DropProperties.setDefaultProperty("all", "centerX", Integer.class, 0);
        DropProperties.setDefaultProperty("all", "centerY", Integer.class, 0);
        DropProperties.setDefaultProperty("all", "centerZ", Integer.class, 0);
        DropProperties.setDefaultProperty("all", "rotation", Integer.class, 0);
        DropProperties.setDefaultProperty("all", "doUpdate", Boolean.class, false);
        DropProperties.setDefaultProperty("all", "blockMode", String.class, "replace");
        DropProperties.setDefaultProperty("all", "displayCommandOutput", Boolean.class, false);
        DropProperties.setDefaultProperty("all", "commandSender", String.class, "@");
        DropProperties.setDefaultProperty("all", "duration", Integer.class, 200);
        DropProperties.setDefaultProperty("all", "NBTTag", NBTTagCompound.class, null);
    }

    public static void registerFunctions() {
        DropFunction.registerDropFunction(new DropFuncBlock());
        DropFunction.registerDropFunction(new DropFuncCommand());
        DropFunction.registerDropFunction(new DropFuncDifficulty());
        DropFunction.registerDropFunction(new DropFuncEffect());
        DropFunction.registerDropFunction(new DropFuncEntity());
        DropFunction.registerDropFunction(new DropFuncExplosion());
        DropFunction.registerDropFunction(new DropFuncFill());
        DropFunction.registerDropFunction(new DropFuncItem());
        DropFunction.registerDropFunction(new DropFuncMessage());
        DropFunction.registerDropFunction(new DropFuncParticle());
        DropFunction.registerDropFunction(new DropFuncSound());
        DropFunction.registerDropFunction(new DropFuncStructure());
        DropFunction.registerDropFunction(new DropFuncTime());
        DropFunction.registerDropFunction(new DropFuncNothing());
        DropFunction.registerGlobalProperties();
    }

    public static DropFunction getDropFunction(DropProperties dropProperties) {
        return DropFunction.getDropFunction(dropProperties.getPropertyString("type"));
    }

    public static DropFunction getDropFunction(String type) {
        return dropFunctions.get(type);
    }

    public static void registerDropFunction(DropFunction dropFunction) {
        dropFunctions.put(dropFunction.getType(), dropFunction);
        dropFunction.registerProperties();
    }
}

