/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import mod.lucky.Lucky;
import mod.lucky.drop.DropContainer;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.item.ItemLuckyPotion;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityLuckyPotion
extends EntityThrowable {
    private static final DataParameter<ItemStack> POTION_ITEM = EntityDataManager.func_187226_a(EntityLuckyPotion.class, (DataSerializer)DataSerializers.field_187196_f);
    private ItemStack itemLuckyPotion = null;
    private DropProcessor impactDropProcessor;
    private int luck = 0;
    private String[] customDrops = null;

    public EntityLuckyPotion(World world) {
        super(world);
    }

    public EntityLuckyPotion(World world, EntityLivingBase thrower) {
        this(world, thrower, Lucky.lucky_potion, new DropProcessor(), 0, null);
    }

    public EntityLuckyPotion(World world, EntityLivingBase thrower, ItemLuckyPotion itemLuckyPotion, DropProcessor impactDropProcessor, int luck, String[] customDrops) {
        super(world, thrower);
        this.itemLuckyPotion = new ItemStack((Item)itemLuckyPotion, 1);
        this.field_70180_af.func_187227_b(POTION_ITEM, (Object)this.itemLuckyPotion);
        this.impactDropProcessor = impactDropProcessor;
        this.luck = luck;
        this.customDrops = customDrops;
    }

    public EntityLuckyPotion(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.impactDropProcessor == null) {
            this.impactDropProcessor = new DropProcessor();
        }
        this.field_70180_af.func_187214_a(POTION_ITEM, (Object)new ItemStack(Items.field_151055_y));
    }

    public ItemStack getItemLuckyPotion() {
        return (ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    private void luckyImpact(Entity hitEntity) {
        try {
            if (this.impactDropProcessor != null && this.impactDropProcessor.getDrops().size() > 0) {
                Vec3d impactPos;
                Vec3d vec3d = impactPos = hitEntity == null ? this.func_174791_d() : hitEntity.func_174791_d();
                if (this.customDrops != null && this.customDrops.length != 0) {
                    this.impactDropProcessor.processRandomDrop(LuckyFunction.getDropsFromStringArray(this.customDrops), new DropProcessData(this.func_130014_f_(), (Entity)this.func_85052_h(), impactPos).setHitEntity(hitEntity), this.luck);
                } else {
                    this.impactDropProcessor.processRandomDrop(new DropProcessData(this.func_130014_f_(), (Entity)this.func_85052_h(), impactPos).setHitEntity(hitEntity), this.luck);
                }
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Potion encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
    }

    public void func_70071_h_() {
        try {
            if (this.itemLuckyPotion == null && this.func_130014_f_().field_72995_K) {
                this.itemLuckyPotion = (ItemStack)this.field_70180_af.func_187225_a(POTION_ITEM);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_70030_z();
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult rayTraceResult) {
        if (!this.field_70170_p.field_72995_K) {
            this.luckyImpact(rayTraceResult.field_72308_g);
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        NBTTagList drops = new NBTTagList();
        for (int i = 0; i < this.impactDropProcessor.getDrops().size(); ++i) {
            drops.func_74742_a((NBTBase)new NBTTagString(this.impactDropProcessor.getDrops().get(i).toString()));
        }
        tagCompound.func_74782_a("impact", (NBTBase)drops);
        tagCompound.func_74782_a("itemLuckyPotion", (NBTBase)this.getItemLuckyPotion().func_77955_b(new NBTTagCompound()));
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        NBTTagList drops = tagCompound.func_150295_c("impact", (int)new NBTTagString().func_74732_a());
        for (int i = 0; i < drops.func_74745_c(); ++i) {
            DropContainer drop = new DropContainer();
            drop.readFromString(drops.func_150307_f(i));
            this.impactDropProcessor.registerDrop(drop);
        }
        if (tagCompound.func_74764_b("itemLuckyPotion")) {
            this.itemLuckyPotion = new ItemStack(tagCompound.func_74775_l("itemLuckyPotion"));
        }
    }
}

