/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.resources;

import java.util.HashMap;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.resources.BaseResource;
import mod.lucky.resources.loader.BaseLoader;
import mod.lucky.util.LuckyReader;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ResourceRecipes
extends BaseResource {
    @Override
    public void process(LuckyReader reader, BaseLoader loader) {
        try {
            String curLine;
            while ((curLine = reader.readLine()) != null) {
                int i;
                String[] recipePart = curLine.split(",");
                NonNullList ingredients = NonNullList.func_191196_a();
                ItemStack result = new ItemStack((Block)loader.getBlock());
                if (ResourceRecipes.getIngredient(recipePart[0]) != null) {
                    for (String part : recipePart) {
                        Ingredient ingredient = ResourceRecipes.getIngredient(part);
                        if (ingredient == null) continue;
                        ingredients.add((Object)ingredient);
                    }
                    loader.getBlock().setBlockRecipe((IForgeRegistryEntry.Impl<IRecipe>)new ShapelessRecipes("lucky", result, ingredients));
                    continue;
                }
                HashMap<Character, Ingredient> ingredientKeys = new HashMap<Character, Ingredient>();
                ingredientKeys.put(Character.valueOf(' '), Ingredient.field_193370_a);
                int recipeEnd = 0;
                for (i = recipePart.length - 1; i > 0; i -= 2) {
                    Ingredient ingredient = ResourceRecipes.getIngredient(recipePart[i]);
                    if (ingredient == null) {
                        recipeEnd = i;
                        break;
                    }
                    ingredientKeys.put(Character.valueOf(recipePart[i - 1].toCharArray()[0]), ingredient);
                }
                for (i = 0; i <= recipeEnd; ++i) {
                    for (char c : recipePart[i].toCharArray()) {
                        ingredients.add(ingredientKeys.get(Character.valueOf(c)));
                    }
                }
                int width = recipePart[0].length();
                int height = recipeEnd + 1;
                loader.getBlock().setBlockRecipe((IForgeRegistryEntry.Impl<IRecipe>)new ShapedRecipes("lucky", width, height, ingredients, result));
            }
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error reading 'recipes.txt'");
            e.printStackTrace();
        }
    }

    private static Ingredient getIngredient(String s) {
        Item item = ValueParser.getItem(s, null);
        ItemStack itemStack = ValueParser.getItemStack(s, null);
        if (item != null) {
            return Ingredient.func_193367_a((Item)item);
        }
        if (itemStack != null) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack});
        }
        return null;
    }

    @Override
    public String getDirectory() {
        return "recipes.txt";
    }

    @Override
    public boolean postInit() {
        return true;
    }
}

