/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import java.io.InputStream;
import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFunction;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.value.DropStringUtils;
import mod.lucky.drop.value.ValueParser;
import mod.lucky.resources.ResourceStructureFile;
import mod.lucky.resources.loader.BaseLoader;
import mod.lucky.structure.LuckyStructure;
import mod.lucky.structure.SchematicStructure;
import net.minecraft.util.math.Vec3d;

public class Structure {
    public static final int STRUCTURE_BLOCK_LIMIT = 100000;
    protected int length;
    protected int height;
    protected int width;
    protected String fileName;
    protected InputStream fileStream;
    protected String overlayStruct;
    protected String id;
    protected String blockMode = "replace";
    protected boolean blockUpdate = true;
    protected Float centerX;
    protected Float centerY;
    protected Float centerZ;
    protected Vec3d centerPos;

    public void readProperties(String properties, BaseLoader loader) {
        String[] splitProperties;
        for (String property : splitProperties = properties.split(",")) {
            String[] splitProperty = property.split("=");
            String propertyName = splitProperty[0];
            String propertyValue = splitProperty[1];
            if (propertyName.equalsIgnoreCase("ID")) {
                this.id = ValueParser.getString(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("overlayStruct")) {
                this.overlayStruct = ValueParser.getString(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("file")) {
                this.fileName = ValueParser.getString(propertyValue);
                this.fileStream = loader.getResourceStream(new ResourceStructureFile(this.fileName));
            }
            if (propertyName.equalsIgnoreCase("centerX")) {
                this.centerX = DropStringUtils.isGenericFloat(propertyValue) ? ValueParser.getFloat(propertyValue) : Float.valueOf(ValueParser.getFloat(propertyValue).floatValue() + (DropStringUtils.isGenericFloat(propertyValue) ? 0.0f : 0.5f));
            }
            if (propertyName.equalsIgnoreCase("centerY")) {
                this.centerY = ValueParser.getFloat(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("centerZ")) {
                this.centerZ = DropStringUtils.isGenericFloat(propertyValue) ? ValueParser.getFloat(propertyValue) : Float.valueOf(ValueParser.getFloat(propertyValue).floatValue() + (DropStringUtils.isGenericFloat(propertyValue) ? 0.0f : 0.5f));
            }
            if (propertyName.equalsIgnoreCase("blockMode")) {
                this.blockMode = ValueParser.getString(propertyValue);
            }
            if (!propertyName.equalsIgnoreCase("blockUpdate")) continue;
            this.blockUpdate = ValueParser.getBoolean(propertyValue);
        }
    }

    public Structure newTypeInstance() {
        if (this.fileName.endsWith(".luckystruct")) {
            return new LuckyStructure().copyProperties(this);
        }
        return new SchematicStructure().copyProperties(this);
    }

    public void readFromFile() {
    }

    public void process(DropProcessData processData) {
    }

    protected void processOverlay(DropProcessData processData) {
        if (this.overlayStruct != null) {
            DropProperties drop = processData.getDropProperties();
            String oldId = drop.getPropertyString("ID");
            String oldBlockMode = drop.getPropertyString("blockMode");
            drop.setProperty("ID", this.overlayStruct);
            drop.setProperty("blockMode", "overlay");
            DropFunction.getDropFunction(drop).process(processData);
            drop.setProperty("ID", oldId);
            drop.setProperty("blockMode", oldBlockMode);
        }
    }

    public String getId() {
        return this.id;
    }

    public Vec3d getCenterPos() {
        return this.centerPos;
    }

    protected void initCenterPos() {
        int defaultCenterX = (int)((float)this.length / 2.0f);
        int defaultCenterZ = (int)((float)this.width / 2.0f);
        if (this.centerX == null) {
            this.centerX = Float.valueOf((float)defaultCenterX + 0.5f);
        }
        if (this.centerY == null) {
            this.centerY = Float.valueOf(0.0f);
        }
        if (this.centerZ == null) {
            this.centerZ = Float.valueOf((float)defaultCenterZ + 0.5f);
        }
        this.centerPos = new Vec3d((double)this.centerX.floatValue(), (double)this.centerY.floatValue(), (double)this.centerZ.floatValue());
    }

    public Structure copyProperties(Structure structure) {
        this.fileName = structure.fileName;
        this.fileStream = structure.fileStream;
        this.id = structure.id;
        this.overlayStruct = structure.overlayStruct;
        this.centerX = structure.centerX;
        this.centerY = structure.centerY;
        this.centerZ = structure.centerZ;
        this.centerPos = structure.centerPos;
        this.blockMode = structure.blockMode;
        this.blockUpdate = structure.blockUpdate;
        this.length = structure.length;
        this.height = structure.height;
        this.width = structure.width;
        return this;
    }
}

