/*
 * Decompiled with CFR 0.152.
 */
package io.github.chaosunity.forgelin;

import com.google.common.collect.SetMultimap;
import io.github.chaosunity.forgelin.KotlinAdapter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002J\u0014\u0010\u001c\u001a\u00020\u001a2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J \u0010\u001e\u001a\u0004\u0018\u00010\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000f2\u0006\u0010!\u001a\u00020 H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010!\u001a\u00020 H\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/github/chaosunity/forgelin/ForgelinAutomaticEventSubscriber;", "", "<init>", "()V", "DEFAULT_SUBSCRIPTION_SIDES", "Ljava/util/EnumSet;", "Lnet/minecraftforge/fml/relauncher/Side;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "AVAILABLE_KT_ADAPTERS", "", "", "[Ljava/lang/String;", "unregistered", "", "Ljava/lang/Class;", "registered", "subscribeAutomatic", "", "mod", "Lnet/minecraftforge/fml/common/ModContainer;", "asm", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;", "currentSide", "hasObjectEventHandlers", "", "objectInstance", "hasStaticEventHandlers", "clazz", "parseModId", "containedMods", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable$ASMData;", "subscriber", "parseTargetSides", "Forgelin-Continuous"})
@SourceDebugExtension(value={"SMAP\nForgelinAutomaticEventSubscriber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForgelinAutomaticEventSubscriber.kt\nio/github/chaosunity/forgelin/ForgelinAutomaticEventSubscriber\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,130:1\n774#2:131\n865#2,2:132\n12637#3,2:134\n12637#3,2:136\n*S KotlinDebug\n*F\n+ 1 ForgelinAutomaticEventSubscriber.kt\nio/github/chaosunity/forgelin/ForgelinAutomaticEventSubscriber\n*L\n32#1:131\n32#1:132,2\n98#1:134,2\n104#1:136,2\n*E\n"})
public final class ForgelinAutomaticEventSubscriber {
    @NotNull
    public static final ForgelinAutomaticEventSubscriber INSTANCE = new ForgelinAutomaticEventSubscriber();
    private static final EnumSet<Side> DEFAULT_SUBSCRIPTION_SIDES = EnumSet.allOf(Side.class);
    private static final Logger LOGGER = LogManager.getLogger(ForgelinAutomaticEventSubscriber.class);
    @NotNull
    private static final String[] AVAILABLE_KT_ADAPTERS;
    @NotNull
    private static final Set<Class<?>> unregistered;
    @NotNull
    private static final Set<Object> registered;

    private ForgelinAutomaticEventSubscriber() {
    }

    /*
     * WARNING - void declaration
     */
    public final void subscribeAutomatic(@NotNull ModContainer mod, @NotNull ASMDataTable asm, @NotNull Side currentSide) {
        Object it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(mod, "mod");
        Intrinsics.checkNotNullParameter(asm, "asm");
        Intrinsics.checkNotNullParameter(currentSide, "currentSide");
        SetMultimap setMultimap = asm.getAnnotationsFor(mod);
        if (setMultimap == null) {
            return;
        }
        SetMultimap modAnnotations = setMultimap;
        Set containedMods = modAnnotations.get((Object)Mod.class.getName());
        Set set = modAnnotations.get((Object)Mod.EventBusSubscriber.class.getName());
        Intrinsics.checkNotNullExpressionValue(set, "get(...)");
        Iterable iterable = set;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASMDataTable.ASMData)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!INSTANCE.parseTargetSides((ASMDataTable.ASMData)it).contains(currentSide)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List subscribers = (List)destination$iv$iv;
        ModClassLoader loader = Loader.instance().getModClassLoader();
        for (ASMDataTable.ASMData containedMod : containedMods) {
            Object v = containedMod.getAnnotationInfo().get("modid");
            Intrinsics.checkNotNull(v, "null cannot be cast to non-null type kotlin.String");
            String containedModId = (String)v;
            if (!ArraysKt.contains(AVAILABLE_KT_ADAPTERS, containedMod.getAnnotationInfo().get("modLanguageAdapter"))) {
                LOGGER.debug("Skipping @EventBusSubscriber injection for {} since it does not use KotlinAdapter", (Object)containedModId);
                continue;
            }
            LOGGER.debug("Attempting to register Kotlin @EventBusSubscriber objects for {}", (Object)containedModId);
            for (ASMDataTable.ASMData subscriber : subscribers) {
                try {
                    Class<?> subscriberClass;
                    KClass<?> kotlinClass;
                    Object object;
                    Intrinsics.checkNotNull(containedMods);
                    Intrinsics.checkNotNull(subscriber);
                    String ownerModId = this.parseModId(containedMods, subscriber);
                    it = ownerModId;
                    if (it == null || it.length() == 0) {
                        LOGGER.debug("Could not determine owning mod for @EventBusSubscriber on {} for mod {}", (Object)subscriber.getClassName(), (Object)mod.getModId());
                        continue;
                    }
                    if (!Intrinsics.areEqual(containedModId, ownerModId)) {
                        LOGGER.debug("Skipping @EventBusSubscriber injection for {} since it is not for mod {}", (Object)subscriber.getClassName(), (Object)containedModId);
                        continue;
                    }
                    if (Class.forName(subscriber.getClassName(), false, (ClassLoader)loader) == null || (object = (kotlinClass = JvmClassMappingKt.getKotlinClass(subscriberClass)).getObjectInstance()) == null && (object = KClasses.getCompanionObjectInstance(kotlinClass)) == null) continue;
                    Object objectInstance = object;
                    if (!this.hasStaticEventHandlers(subscriberClass) && !unregistered.contains(subscriberClass)) {
                        MinecraftForge.EVENT_BUS.unregister(subscriberClass);
                        ((Collection)unregistered).add(subscriberClass);
                        LOGGER.debug("Unregistered static @EventBusSubscriber class {}", (Object)subscriber.getClassName());
                    }
                    if (!this.hasObjectEventHandlers(objectInstance) || registered.contains(objectInstance)) continue;
                    MinecraftForge.EVENT_BUS.register(objectInstance);
                    ((Collection)registered).add(objectInstance);
                    LOGGER.debug("Registered @EventBusSubscriber object instance {}", (Object)subscriber.getClassName());
                }
                catch (Throwable e) {
                    LOGGER.error("An error occurred trying to load an @EventBusSubscriber object {} for modid {}", (Object)mod.getModId(), (Object)e);
                    throw new LoaderException(e);
                }
            }
        }
    }

    private final boolean hasObjectEventHandlers(Object objectInstance) {
        boolean bl;
        block1: {
            Method[] methodArray = objectInstance.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue(methodArray, "getMethods(...)");
            Object[] $this$any$iv = methodArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Method it = (Method)element$iv;
                boolean bl2 = false;
                if (!(!Modifier.isStatic(it.getModifiers()) && it.isAnnotationPresent(SubscribeEvent.class))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasStaticEventHandlers(Class<?> clazz) {
        boolean bl;
        block1: {
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue(methodArray, "getMethods(...)");
            Object[] $this$any$iv = methodArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Method it = (Method)element$iv;
                boolean bl2 = false;
                if (!(Modifier.isStatic(it.getModifiers()) && it.isAnnotationPresent(SubscribeEvent.class))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final String parseModId(Set<ASMDataTable.ASMData> containedMods, ASMDataTable.ASMData subscriber) {
        Object object = subscriber.getAnnotationInfo().get("modid");
        String parsedModId = object instanceof String ? (String)object : null;
        object = parsedModId;
        if (object == null || object.length() == 0) {
            return parsedModId;
        }
        return ASMDataTable.getOwnerModID(containedMods, (ASMDataTable.ASMData)subscriber);
    }

    private final EnumSet<Side> parseTargetSides(ASMDataTable.ASMData subscriber) {
        List parsedSides;
        Object v = subscriber.getAnnotationInfo().get("value");
        List list = parsedSides = v instanceof List ? (List)v : null;
        if (parsedSides != null) {
            EnumSet<Side> targetSides = EnumSet.noneOf(Side.class);
            for (ModAnnotation.EnumHolder parsed : parsedSides) {
                String string = parsed.getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                targetSides.add(Side.valueOf((String)string));
            }
            Intrinsics.checkNotNull(targetSides);
            return targetSides;
        }
        EnumSet<Side> enumSet = DEFAULT_SUBSCRIPTION_SIDES;
        Intrinsics.checkNotNullExpressionValue(enumSet, "DEFAULT_SUBSCRIPTION_SIDES");
        return enumSet;
    }

    static {
        String[] stringArray = new String[]{Reflection.getOrCreateKotlinClass(KotlinAdapter.class).getQualifiedName(), Reflection.getOrCreateKotlinClass(net.shadowfacts.forgelin.KotlinAdapter.class).getQualifiedName()};
        AVAILABLE_KT_ADAPTERS = stringArray;
        unregistered = new LinkedHashSet();
        registered = new LinkedHashSet();
    }
}

