# Нанороботы

![Нанороботы, Карл.](oredict:oc:nanomachines)

Это миниатюрные устройства, которые интегрируются с вашей нервной системой, чтобы сделать вас сильнее, лучше и быстрее или убить вас. Иногда все вместе. Проще говоря, нанороботы предоставляют систему, работающую на энергии и дающие игроку положительными (и отрицательными) эффектами. Съешьте нанороботов, чтобы ввести их в организм.

После введения появляется новый индикатор энергии, который показывает, сколько осталось энергии в ваших нанороботах. Вы можете перезарядить их, если встанете у [зарядного устройства](../block/charger.md). Чем активнее вы используете нанороботов, тем больше энергии они потребляют.

Нанороботы имеют некоторое количество "контактов", которые при активации могут накладывать на игрока различные эффекты, начиная с визуальных эффектов, таких как частицы, появляющиеся рядом с игроком, и заканчивая эффектами от зелий и некоторыми даже более редкими и особыми эффектами!

Какой эффект получится при активации контакта, зависит от текущей конфигурации нанороботов, где сами связи между контактами и эффектами случайны для каждой конфигурации. Это означает, что потребуется активировать различные контакты, чтобы узнать, что они делают. Если вам не повезло с конфигурацией, вы всегда можете переконфигурировать ваших нанороботов, съев еще. Если вы захотите избавиться от них, выпейте [кислоту](acid.md). Помните, что большое количество одновременно активных контактов будет давать серьезные отрицательные эффекты!

По умолчанию нанороботы находятся в режиме ожидания. Вы можете контролировать их с помощью беспроводных сообщений, поэтому рекомендуется носить с собою [планшет](tablet.md) с [беспроводной сетевой картой](wlanCard1.md). Нанороботы реагируют только на беспроводные сигналы, источник которых находится не дальше двух метров, но они реагируют на все сообщения на любом порту и с любых устройств!

Нанороботы работают по простому проепритарному протоколу: каждый пакет должен состоять из множества частей, где первый - это "заголовок", и он должен быть строкой с текстом `nanomachines`. Вторая часть должна быть именем команды. Остальные части - это параметры для команды. Доступны следующие команды (форматировано как `имякоманды(параметр1, ...)`):

- `setResponsePort(port:number)` - установить порт, на который будут отправляться ответные сообщения от нанороботов.
- `getPowerState()` - запросить текущее и максимальное количества энергии нанороботов.
- `getHealth()` - запросить состояние здоровья игрока.
- `getHunger()` - запросить уровень голода игрока.
- `getAge()` - запросить возраст игрока в секундах.
- `getName()` - запросить имя игрока.
- `getExperience()` - запросить уровень опыта игрока.
- `getTotalInputCount()` - запросить общее количества доступных контактов.
- `getSafeActiveInputs()` - запросить максимальное *безопасное* количество активных контактов.
- `getMaxActiveInputs()` - запросить *максимальное* количество активных контактов.
- `getInput(index:number)` - запросить текущее состояние контакта с указанным индексом.
- `setInput(index:number, value:boolean)` - устанавливает указанный контакт в указанное состояние.
- `getActiveEffects()` - запросить список активных эффектов. Некоторые эффекты могут быть не показаны в этом списке.
- `saveConfiguration()` - при наличии в инвентаре нанороботов сохраняет текущую конфигурацию в них.

Например, в OpenOS:
- `component.modem.broadcast(1, "nanomachines", "setInput", 1, true)` активирует первый контакт.
- `component.modem.broadcast(1, "nanomachines", "getHealth")` запросит информации о состоянии здоровья игрока.
