/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.example;

import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class BasicTerminalExample {
    private static final char ESC = '\u001b';

    private static void writeTerminalCommands(@NotNull PipedWriter writer) throws IOException {
        writer.write("\u001b%G");
        writer.write("\u001b[31m");
        writer.write("Hello\r\n");
        writer.write("\u001b[32;43m");
        writer.write("World\r\n");
    }

    @NotNull
    private static JediTermWidget createTerminalWidget() {
        JediTermWidget widget = new JediTermWidget(80, 24, new DefaultSettingsProvider());
        PipedWriter terminalWriter = new PipedWriter();
        widget.setTtyConnector(new ExampleTtyConnector(terminalWriter));
        widget.start();
        try {
            BasicTerminalExample.writeTerminalCommands(terminalWriter);
            terminalWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return widget;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Basic Terminal Example");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(BasicTerminalExample.createTerminalWidget());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(BasicTerminalExample::createAndShowGUI);
    }

    private static class ExampleTtyConnector
    implements TtyConnector {
        private final PipedReader myReader;

        public ExampleTtyConnector(@NotNull PipedWriter writer) {
            try {
                this.myReader = new PipedReader(writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public int read(char[] buf, int offset, int length) throws IOException {
            return this.myReader.read(buf, offset, length);
        }

        @Override
        public void write(byte[] bytes) {
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public void write(String string) {
        }

        @Override
        public int waitFor() {
            return 0;
        }

        @Override
        public boolean ready() throws IOException {
            return this.myReader.ready();
        }
    }
}

