/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.TerminalLine;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jediterm/terminal/model/CyclicBufferLinesStorage;", "Lcom/jediterm/terminal/model/LinesStorage;", "maxCapacity", "", "<init>", "(I)V", "lines", "Lkotlin/collections/ArrayDeque;", "Lcom/jediterm/terminal/model/TerminalLine;", "isCapacityLimited", "", "size", "getSize", "()I", "get", "index", "indexOf", "line", "addToTop", "", "addToBottom", "removeFromTop", "removeFromBottom", "clear", "iterator", "", "core"})
public final class CyclicBufferLinesStorage
implements LinesStorage {
    private final int maxCapacity;
    @NotNull
    private final ArrayDeque<TerminalLine> lines;
    private final boolean isCapacityLimited;

    public CyclicBufferLinesStorage(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.lines = new ArrayDeque();
        this.isCapacityLimited = this.maxCapacity >= 0;
    }

    @Override
    public int getSize() {
        return this.lines.size();
    }

    @Override
    @NotNull
    public TerminalLine get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index >= this.getSize()) {
            int n = index - this.getSize() + 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                TerminalLine terminalLine = TerminalLine.createEmpty();
                Intrinsics.checkNotNullExpressionValue(terminalLine, "createEmpty(...)");
                this.addToBottom(terminalLine);
            }
        }
        return this.lines.get(index);
    }

    @Override
    public int indexOf(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter(line, "line");
        return this.lines.indexOf(line);
    }

    @Override
    public void addToTop(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter(line, "line");
        if (this.isCapacityLimited && this.lines.size() == this.maxCapacity) {
            return;
        }
        this.lines.addFirst(line);
    }

    @Override
    public void addToBottom(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter(line, "line");
        this.lines.addLast(line);
        if (this.isCapacityLimited && this.lines.size() > this.maxCapacity) {
            this.lines.removeFirst();
        }
    }

    @Override
    @NotNull
    public TerminalLine removeFromTop() {
        return this.lines.removeFirst();
    }

    @Override
    @NotNull
    public TerminalLine removeFromBottom() {
        return this.lines.removeLast();
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    @NotNull
    public Iterator<TerminalLine> iterator() {
        return this.lines.iterator();
    }
}

