/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.ui.debug;

import com.jediterm.terminal.StyledTextConsumerAdapter;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesStorageKt;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jediterm/ui/debug/TerminalDebugUtil;", "", "<init>", "()V", "getStyleLines", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "JediTerm"})
public final class TerminalDebugUtil {
    @NotNull
    public static final TerminalDebugUtil INSTANCE = new TerminalDebugUtil();

    private TerminalDebugUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String getStyleLines(@NotNull TerminalTextBuffer textBuffer) {
        Intrinsics.checkNotNullParameter(textBuffer, "textBuffer");
        Map style2IdMap = new HashMap();
        textBuffer.lock();
        try {
            StringBuilder sb = new StringBuilder();
            LinesStorageKt.processLines$default(textBuffer.getScreenLinesStorage(), 0, textBuffer.getHeight(), new StyledTextConsumerAdapter(sb, style2IdMap){
                private int count;
                final /* synthetic */ StringBuilder $sb;
                final /* synthetic */ Map<Integer, Integer> $style2IdMap;
                {
                    this.$sb = $sb;
                    this.$style2IdMap = $style2IdMap;
                }

                public final int getCount() {
                    return this.count;
                }

                public final void setCount(int n) {
                    this.count = n;
                }

                public void consume(int x, int y, TextStyle style, CharBuffer characters, int startRow) {
                    Object object;
                    Object object2;
                    int styleNum;
                    Intrinsics.checkNotNullParameter(style, "style");
                    Intrinsics.checkNotNullParameter(characters, "characters");
                    if (x == 0) {
                        this.$sb.append("\n");
                    }
                    if (!this.$style2IdMap.containsKey(styleNum = style.hashCode())) {
                        Map<Integer, Integer> map = this.$style2IdMap;
                        object2 = styleNum;
                        int n = this.count;
                        this.count = n + 1;
                        object = n;
                        map.put((Integer)object2, (Integer)object);
                    }
                    object2 = "%02d ";
                    object = new Object[]{this.$style2IdMap.get(styleNum)};
                    String string = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
                    Intrinsics.checkNotNullExpressionValue(string, "format(...)");
                    this.$sb.append(string);
                }
            }, 0, 8, null);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = string;
            return string2;
        }
        finally {
            textBuffer.unlock();
        }
    }
}

